/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.component;

import java.util.Collection;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.component.JavaComponent;
import org.mule.runtime.core.api.component.LifecycleAdapter;
import org.mule.runtime.core.api.component.LifecycleAdapterFactory;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.model.EntryPointResolver;
import org.mule.runtime.core.api.model.EntryPointResolverSet;
import org.mule.runtime.core.api.model.resolvers.DefaultEntryPointResolverSet;
import org.mule.runtime.core.api.model.resolvers.LegacyEntryPointResolverSet;
import org.mule.runtime.core.api.object.ObjectFactory;
import org.mule.runtime.core.component.AbstractComponent;
import org.mule.runtime.core.component.DefaultComponentLifecycleAdapterFactory;
import org.mule.runtime.core.component.NullLifecycleAdapter;
import org.mule.runtime.core.config.i18n.CoreMessages;

public abstract class AbstractJavaComponent
extends AbstractComponent
implements JavaComponent {
    protected EntryPointResolverSet entryPointResolverSet;
    protected ObjectFactory objectFactory;
    protected LifecycleAdapterFactory lifecycleAdapterFactory;

    public AbstractJavaComponent() {
    }

    public AbstractJavaComponent(ObjectFactory objectFactory) {
        this(objectFactory, null);
    }

    public AbstractJavaComponent(ObjectFactory objectFactory, EntryPointResolverSet entryPointResolverSet) {
        this.entryPointResolverSet = entryPointResolverSet;
        this.objectFactory = objectFactory;
    }

    @Override
    protected Object doInvoke(Event event, Event.Builder eventBuilder) throws Exception {
        return this.invokeComponentInstance(event, eventBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeComponentInstance(Event event, Event.Builder eventBuilder) throws Exception {
        LifecycleAdapter componentLifecycleAdapter = null;
        try {
            componentLifecycleAdapter = this.borrowComponentLifecycleAdaptor();
            Object object = componentLifecycleAdapter.invoke(event, eventBuilder);
            return object;
        }
        finally {
            if (componentLifecycleAdapter != null) {
                this.returnComponentLifecycleAdaptor(componentLifecycleAdapter);
            }
        }
    }

    @Override
    public Class<?> getObjectType() {
        return this.objectFactory.getObjectClass();
    }

    protected LifecycleAdapter createLifecycleAdaptor() throws Exception {
        Object object = this.objectFactory.getInstance(this.muleContext);
        LifecycleAdapter lifecycleAdapter = this.lifecycleAdapterFactory != null ? this.lifecycleAdapterFactory.create(object, this, this.flowConstruct, this.entryPointResolverSet, this.muleContext) : (this.objectFactory.isExternallyManagedLifecycle() ? new NullLifecycleAdapter(object, this, this.flowConstruct, this.entryPointResolverSet, this.muleContext) : new DefaultComponentLifecycleAdapterFactory().create(object, this, this.flowConstruct, this.entryPointResolverSet, this.muleContext));
        if (object instanceof FlowConstructAware) {
            ((FlowConstructAware)object).setFlowConstruct(this.flowConstruct);
        }
        lifecycleAdapter.initialise();
        return lifecycleAdapter;
    }

    protected abstract LifecycleAdapter borrowComponentLifecycleAdaptor() throws Exception;

    protected abstract void returnComponentLifecycleAdaptor(LifecycleAdapter var1) throws Exception;

    @Override
    protected void doInitialise() throws InitialisationException {
        if (this.objectFactory == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("object factory"), (Initialisable)this);
        }
        this.objectFactory.initialise();
    }

    @Override
    protected void doStart() throws MuleException {
        if (this.entryPointResolverSet == null) {
            this.entryPointResolverSet = new LegacyEntryPointResolverSet();
        }
    }

    @Override
    protected void doDispose() {
        if (this.objectFactory != null) {
            this.objectFactory.dispose();
        }
    }

    @Override
    public EntryPointResolverSet getEntryPointResolverSet() {
        return this.entryPointResolverSet;
    }

    @Override
    public void setEntryPointResolverSet(EntryPointResolverSet entryPointResolverSet) {
        this.entryPointResolverSet = entryPointResolverSet;
    }

    public void setEntryPointResolvers(Collection<EntryPointResolver> entryPointResolvers) {
        if (null == this.entryPointResolverSet) {
            this.entryPointResolverSet = new DefaultEntryPointResolverSet();
        }
        for (EntryPointResolver resolver : entryPointResolvers) {
            this.entryPointResolverSet.addEntryPointResolver(resolver);
        }
    }

    @Override
    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    @Override
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
        this.injectService();
    }

    @Override
    public LifecycleAdapterFactory getLifecycleAdapterFactory() {
        return this.lifecycleAdapterFactory;
    }

    @Override
    public void setLifecycleAdapterFactory(LifecycleAdapterFactory lifecycleAdapterFactory) {
        this.lifecycleAdapterFactory = lifecycleAdapterFactory;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
        this.injectService();
    }

    protected void injectService() {
        if (this.objectFactory != null && this.objectFactory instanceof FlowConstructAware && this.flowConstruct != null) {
            ((FlowConstructAware)((Object)this.objectFactory)).setFlowConstruct(this.flowConstruct);
        }
    }
}

