/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.journal.queue;

import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.Collection;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.util.journal.JournalEntry;
import org.mule.runtime.core.internal.util.journal.JournalEntrySerializer;
import org.mule.runtime.core.internal.util.journal.TransactionCompletePredicate;
import org.mule.runtime.core.internal.util.journal.TransactionJournal;
import org.mule.runtime.core.internal.util.journal.queue.AbstractQueueTxJournalEntry;
import org.mule.runtime.core.util.queue.QueueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQueueTransactionJournal<T, K extends JournalEntry<T>> {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private TransactionJournal<T, K> logFile;

    public AbstractQueueTransactionJournal(String logFilesDirectory, JournalEntrySerializer journalEntrySerializer, Integer maximumFileSizeInMegabytes) {
        Preconditions.checkArgument(maximumFileSizeInMegabytes == null || maximumFileSizeInMegabytes > 0, "Maximum tx log file size needs to be greater than zero");
        this.logFile = new TransactionJournal(logFilesDirectory, new TransactionCompletePredicate(){

            @Override
            public boolean isTransactionComplete(JournalEntry journalEntry) {
                AbstractQueueTxJournalEntry abstractQueueTxJournalEntry = (AbstractQueueTxJournalEntry)journalEntry;
                return abstractQueueTxJournalEntry.isCommit() || abstractQueueTxJournalEntry.isRollback();
            }
        }, journalEntrySerializer, maximumFileSizeInMegabytes);
    }

    public void logAdd(T txId, QueueStore queue, Serializable value) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Logging queue add operation for tx " + txId);
        }
        this.logFile.logUpdateOperation((JournalEntry<T>)this.createUpdateJournalEntry(txId, AbstractQueueTxJournalEntry.Operation.ADD.getByteRepresentation(), queue.getName(), value));
    }

    public void logAddFirst(T txId, QueueStore queue, Serializable item) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Logging queue add first operation for tx " + txId);
        }
        this.logFile.logUpdateOperation((JournalEntry<T>)this.createUpdateJournalEntry(txId, AbstractQueueTxJournalEntry.Operation.ADD_FIRST.getByteRepresentation(), queue.getName(), item));
    }

    public void logRemove(T txId, QueueStore queue, Serializable value) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Logging queue remove operation for tx " + txId);
        }
        this.logFile.logUpdateOperation((JournalEntry<T>)this.createUpdateJournalEntry(txId, AbstractQueueTxJournalEntry.Operation.REMOVE.getByteRepresentation(), queue.getName(), value));
    }

    public void logCommit(T txId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Logging queue commit operation for tx " + txId);
        }
        this.logFile.logCheckpointOperation((JournalEntry<T>)this.createCheckpointJournalEntry(txId, AbstractQueueTxJournalEntry.Operation.COMMIT.getByteRepresentation()));
    }

    protected abstract K createUpdateJournalEntry(T var1, byte var2, String var3, Serializable var4);

    protected abstract K createCheckpointJournalEntry(T var1, byte var2);

    public void logRollback(T txId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Logging queue rollback operation for tx " + txId);
        }
        this.logFile.logCheckpointOperation((JournalEntry<T>)this.createCheckpointJournalEntry(txId, AbstractQueueTxJournalEntry.Operation.ROLLBACK.getByteRepresentation()));
    }

    public synchronized void close() {
        this.logFile.close();
    }

    public synchronized void clear() {
        this.logFile.clear();
    }

    public Multimap<T, K> getAllLogEntries() {
        return this.logFile.getAllLogEntries();
    }

    public Collection<K> getLogEntriesForTx(T txId) {
        return this.logFile.getLogEntriesForTx(txId);
    }

    protected TransactionJournal<T, K> getJournal() {
        return this.logFile;
    }
}

