/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.journal.queue;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.internal.util.journal.JournalEntry;

public abstract class AbstractQueueTxJournalEntry<T>
implements JournalEntry<T> {
    private T txId;
    private String queueName;
    private byte operation;
    private Serializable value;

    public AbstractQueueTxJournalEntry(T txId, byte operation, String queueName, Serializable value) {
        this.txId = txId;
        this.queueName = queueName;
        this.operation = operation;
        this.value = value;
    }

    public AbstractQueueTxJournalEntry(T txId, byte operation) {
        this.txId = txId;
        this.operation = operation;
    }

    public AbstractQueueTxJournalEntry(DataInputStream inputStream, MuleContext muleContext) throws IOException {
        this.txId = this.deserializeTxId(inputStream);
        this.operation = inputStream.readByte();
        if (AbstractQueueTxJournalEntry.isCheckpointOperation(this.operation)) {
            return;
        }
        int queueNameSize = this.toUnsignedInt(inputStream.readByte());
        byte[] queueNameAsBytes = new byte[queueNameSize];
        inputStream.read(queueNameAsBytes, 0, queueNameSize);
        int valueSize = inputStream.readInt();
        byte[] valueAsBytes = new byte[valueSize];
        inputStream.read(valueAsBytes, 0, valueSize);
        this.queueName = new String(queueNameAsBytes);
        this.value = (Serializable)muleContext.getObjectSerializer().getInternalProtocol().deserialize(valueAsBytes);
    }

    public void write(DataOutputStream outputStream, MuleContext muleContext) {
        try {
            this.serializeTxId(outputStream);
            outputStream.write(this.operation);
            if (AbstractQueueTxJournalEntry.isCheckpointOperation(this.operation)) {
                outputStream.flush();
                return;
            }
            outputStream.write(this.queueName.length());
            outputStream.write(this.queueName.getBytes());
            byte[] serializedValue = muleContext.getObjectSerializer().getInternalProtocol().serialize(this.value);
            outputStream.writeInt(serializedValue.length);
            outputStream.write(serializedValue);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new MuleRuntimeException(e);
        }
    }

    public static boolean isCheckpointOperation(byte operationAsByte) {
        Operation operation = Operation.createFromByteRepresentation(operationAsByte);
        return operation.equals((Object)Operation.COMMIT) || operation.equals((Object)Operation.ROLLBACK) || operation.equals((Object)Operation.PREPARE);
    }

    public Serializable getValue() {
        return this.value;
    }

    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public T getTxId() {
        return this.txId;
    }

    public byte getOperation() {
        return this.operation;
    }

    public boolean isCommit() {
        return this.operation == Operation.COMMIT.getByteRepresentation();
    }

    public boolean isRollback() {
        return this.operation == Operation.ROLLBACK.getByteRepresentation();
    }

    public boolean isRemove() {
        return this.operation == Operation.REMOVE.getByteRepresentation();
    }

    public boolean isAdd() {
        return this.operation == Operation.ADD.getByteRepresentation();
    }

    public boolean isAddFirst() {
        return this.operation == Operation.ADD_FIRST.getByteRepresentation();
    }

    public boolean isPrepare() {
        return Operation.PREPARE.getByteRepresentation() == this.getOperation();
    }

    private int toUnsignedInt(byte b) {
        return b & 0xFF;
    }

    protected abstract T deserializeTxId(DataInputStream var1) throws IOException;

    protected abstract void serializeTxId(DataOutputStream var1) throws IOException;

    static enum Operation {
        COMMIT(1),
        ROLLBACK(2),
        PREPARE(3),
        REMOVE(4),
        ADD(5),
        ADD_FIRST(6);

        private final byte byteRepresentation;

        private Operation(byte operation) {
            this.byteRepresentation = operation;
        }

        public byte getByteRepresentation() {
            return this.byteRepresentation;
        }

        public static Operation createFromByteRepresentation(byte byteRepresentation) {
            for (Operation operation : Operation.values()) {
                if (operation.byteRepresentation != byteRepresentation) continue;
                return operation;
            }
            throw new MuleRuntimeException(CoreMessages.createStaticMessage("Unexpected byte representation value: " + byteRepresentation));
        }
    }
}

