/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.lifecycle;

import java.lang.reflect.Constructor;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.ServerNotification;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.context.notification.MuleContextNotification;
import org.mule.runtime.core.lifecycle.LifecycleObject;

public class NotificationLifecycleObject
extends LifecycleObject {
    private String preNotificationName;
    private String postNotificationName;
    private Constructor ctor;

    public NotificationLifecycleObject(Class type) {
        super(type);
    }

    public NotificationLifecycleObject(Class type, Class notificationClass) {
        super(type);
        if (notificationClass == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("notificationClass").toString());
        }
        if (!ServerNotification.class.isAssignableFrom(notificationClass = ClassUtils.initializeClass(notificationClass))) {
            throw new ClassCastException("Notification class must be of type: " + ServerNotification.class.getName() + ". Offending class is: " + notificationClass.getName());
        }
        this.ctor = ClassUtils.getConstructor(notificationClass, new Class[]{Object.class, String.class});
        if (this.ctor == null) {
            throw new IllegalArgumentException("No constructor defined in Notification class: " + notificationClass + " with arguments (Object.class, String.class)");
        }
    }

    public NotificationLifecycleObject(Class type, Class notificationClass, int preNotification, int postNotification) {
        this(type, notificationClass);
        this.setPreNotificationName(MuleContextNotification.getActionName(preNotification));
        this.setPostNotificationName(MuleContextNotification.getActionName(postNotification));
    }

    public String getPostNotificationName() {
        return this.postNotificationName;
    }

    public void setPostNotificationName(String postNotificationName) {
        this.postNotificationName = postNotificationName;
    }

    public String getPreNotificationName() {
        return this.preNotificationName;
    }

    public void setPreNotificationName(String preNotificationName) {
        this.preNotificationName = preNotificationName;
    }

    @Override
    public void firePreNotification(MuleContext context) {
        if (this.getPreNotificationName() != null) {
            this.setPreNotification(this.createNotification(context, this.getPreNotificationName()));
        }
        super.firePreNotification(context);
    }

    @Override
    public void firePostNotification(MuleContext context) {
        if (this.getPostNotificationName() != null) {
            this.setPostNotification(this.createNotification(context, this.getPostNotificationName()));
        }
        super.firePostNotification(context);
    }

    protected ServerNotification createNotification(MuleContext context, String action) {
        try {
            return (ServerNotification)this.ctor.newInstance(context, action);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(CoreMessages.failedToCreate("Notification:" + action), (Throwable)e);
        }
    }
}

