/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.lifecycle.processor;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.meta.NameableObject;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.processor.AbstractFilteringMessageProcessor;

public class ProcessIfStartedMessageProcessor
extends AbstractFilteringMessageProcessor {
    protected Startable startable;
    protected LifecycleState lifecycleState;

    public ProcessIfStartedMessageProcessor(Startable startable, LifecycleState lifecycleState) {
        this.startable = startable;
        this.lifecycleState = lifecycleState;
    }

    @Override
    protected boolean accept(Event event, Event.Builder builder) {
        return this.lifecycleState.isStarted();
    }

    @Override
    public boolean isThrowOnUnaccepted() {
        return true;
    }

    @Override
    protected MuleException filterUnacceptedException(Event event) {
        return new LifecycleException(CoreMessages.isStopped(this.getStartableName(this.startable)), (Object)event.getMessage());
    }

    protected String getStartableName(Startable startableObject) {
        if (startableObject instanceof NameableObject) {
            return ((NameableObject)((Object)startableObject)).getName();
        }
        return startableObject.toString();
    }
}

