/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy;

import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplate;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;

public class DefaultPolicyTemplate
implements PolicyTemplate {
    private final String artifactId;
    private final PolicyTemplateDescriptor descriptor;
    private final ArtifactClassLoader policyClassLoader;
    private final List<ArtifactPlugin> artifactPlugins;

    public DefaultPolicyTemplate(String artifactId, PolicyTemplateDescriptor descriptor, ArtifactClassLoader policyClassLoader, List<ArtifactPlugin> artifactPlugins) {
        Preconditions.checkArgument(!StringUtils.isEmpty((String)artifactId), "artifactId cannot be empty");
        Preconditions.checkArgument(descriptor != null, "descriptor cannot be null");
        Preconditions.checkArgument(policyClassLoader != null, "policyClassLoader cannot be null");
        Preconditions.checkArgument(artifactPlugins != null, "artifactPlugins cannot be null");
        this.artifactId = artifactId;
        this.descriptor = descriptor;
        this.policyClassLoader = policyClassLoader;
        this.artifactPlugins = artifactPlugins;
    }

    @Override
    public String getArtifactName() {
        return this.descriptor.getName();
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public PolicyTemplateDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public File[] getResourceFiles() {
        return new File[0];
    }

    @Override
    public ArtifactClassLoader getArtifactClassLoader() {
        return this.policyClassLoader;
    }

    @Override
    public void dispose() {
        this.policyClassLoader.dispose();
    }

    @Override
    public List<ArtifactPlugin> getArtifactPlugins() {
        return this.artifactPlugins;
    }
}

