/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.beanutils.BeanToPropertyValueTransformer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.internal.util.splash.SplashScreen;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.module.artifact.Artifact;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.internal.ArchiveDeployer;
import org.mule.runtime.module.deployment.internal.ArtifactArchiveInstaller;
import org.mule.runtime.module.deployment.internal.ArtifactDeployer;
import org.mule.runtime.module.deployment.internal.ArtifactDeploymentTemplate;
import org.mule.runtime.module.deployment.internal.CompositeDeploymentListener;
import org.mule.runtime.module.deployment.internal.NullDeploymentListener;
import org.mule.runtime.module.deployment.internal.util.ObservableList;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultArchiveDeployer<T extends DeployableArtifact>
implements ArchiveDeployer<T> {
    public static final String ARTIFACT_NAME_PROPERTY = "artifactName";
    public static final String JAR_FILE_SUFFIX = ".jar";
    private static final Logger logger = LoggerFactory.getLogger(DefaultArchiveDeployer.class);
    private final ArtifactDeployer<T> deployer;
    private final ArtifactArchiveInstaller artifactArchiveInstaller;
    private final Map<String, ZombieFile> artifactZombieMap = new HashMap<String, ZombieFile>();
    private final File artifactDir;
    private final ObservableList<T> artifacts;
    private final ArtifactDeploymentTemplate deploymentTemplate;
    private ArtifactFactory<T> artifactFactory;
    private DeploymentListener deploymentListener = new NullDeploymentListener();

    public DefaultArchiveDeployer(ArtifactDeployer deployer, ArtifactFactory artifactFactory, ObservableList<T> artifacts, ArtifactDeploymentTemplate deploymentTemplate) {
        this.deployer = deployer;
        this.artifactFactory = artifactFactory;
        this.artifacts = artifacts;
        this.deploymentTemplate = deploymentTemplate;
        this.artifactDir = artifactFactory.getArtifactDir();
        this.artifactArchiveInstaller = new ArtifactArchiveInstaller(this.artifactDir);
    }

    @Override
    public T deployPackagedArtifact(String zip) throws DeploymentException {
        try {
            String artifactName = StringUtils.removeEndIgnoreCase((String)zip, (String)JAR_FILE_SUFFIX);
            File artifactZip = new File(this.artifactDir, zip);
            URI uri = artifactZip.toURI();
            return this.deployPackagedArtifact(uri, artifactName);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage("Failed to deploy from zip: " + zip), (Throwable)e);
        }
    }

    @Override
    public T deployExplodedArtifact(String artifactDir) throws DeploymentException {
        if (!this.isUpdatedZombieArtifact(artifactDir)) {
            return null;
        }
        return this.deployExplodedApp(artifactDir);
    }

    @Override
    public boolean isUpdatedZombieArtifact(String artifactName) {
        Collection deployedAppNames = CollectionUtils.collect(this.artifacts, (Transformer)new BeanToPropertyValueTransformer(ARTIFACT_NAME_PROPERTY));
        if (deployedAppNames.contains(artifactName) && !this.artifactZombieMap.containsKey(artifactName)) {
            return false;
        }
        ZombieFile zombieFile = this.artifactZombieMap.get(artifactName);
        return zombieFile == null || zombieFile.updatedZombieApp();
    }

    @Override
    public void undeployArtifact(String artifactId) {
        ZombieFile zombieFile = this.artifactZombieMap.get(artifactId);
        if (zombieFile != null) {
            if (zombieFile.exists()) {
                return;
            }
            this.artifactZombieMap.remove(artifactId);
        }
        DeployableArtifact artifact = (DeployableArtifact)CollectionUtils.find(this.artifacts, (Predicate)new BeanPropertyValueEqualsPredicate(ARTIFACT_NAME_PROPERTY, (Object)artifactId));
        this.undeploy(artifact);
    }

    @Override
    public File getDeploymentDirectory() {
        return this.artifactFactory.getArtifactDir();
    }

    @Override
    public T deployPackagedArtifact(URI artifactAchivedUri) throws DeploymentException {
        try {
            T artifact;
            try {
                artifact = this.installFrom(artifactAchivedUri);
                this.trackArtifact(artifact);
            }
            catch (Throwable t) {
                File artifactArchive = new File(artifactAchivedUri);
                String artifactName = StringUtils.removeEndIgnoreCase((String)artifactArchive.getName(), (String)JAR_FILE_SUFFIX);
                this.logDeploymentFailure(t, artifactName);
                this.addZombieFile(artifactName, artifactArchive);
                this.deploymentListener.onDeploymentFailure(artifactName, t);
                throw t;
            }
            this.deployArtifact(artifact);
            return artifact;
        }
        catch (Throwable t) {
            if (t instanceof DeploymentException) {
                throw (DeploymentException)t;
            }
            String msg = "Failed to deploy from URI: " + artifactAchivedUri;
            throw new DeploymentException(I18nMessageFactory.createStaticMessage(msg), t);
        }
    }

    private void logDeploymentFailure(Throwable t, String artifactName) {
        String msg = SplashScreen.miniSplash(String.format("Failed to deploy artifact '%s', see below", artifactName));
        logger.error(msg, t);
    }

    @Override
    public Map<URI, Long> getArtifactsZombieMap() {
        HashMap<URI, Long> result = new HashMap<URI, Long>();
        for (String artifact : this.artifactZombieMap.keySet()) {
            ZombieFile file = this.artifactZombieMap.get(artifact);
            result.put(file.uri, file.originalTimestamp);
        }
        return result;
    }

    @Override
    public void setArtifactFactory(ArtifactFactory<T> artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    @Override
    public void undeployArtifactWithoutUninstall(T artifact) {
        this.logRequestToUndeployArtifact(artifact);
        try {
            this.deploymentListener.onUndeploymentStart(artifact.getArtifactName());
            this.deployer.undeploy(artifact);
            this.deploymentListener.onUndeploymentSuccess(artifact.getArtifactName());
        }
        catch (DeploymentException e) {
            this.deploymentListener.onUndeploymentFailure(artifact.getArtifactName(), e);
            throw e;
        }
    }

    ArtifactDeployer getDeployer() {
        return this.deployer;
    }

    @Override
    public void setDeploymentListener(CompositeDeploymentListener deploymentListener) {
        this.deploymentListener = deploymentListener;
    }

    private T deployPackagedArtifact(URI artifactUri, String artifactName) throws IOException {
        ZombieFile zombieFile = this.artifactZombieMap.get(artifactName);
        if (zombieFile != null && zombieFile.isFor(artifactUri) && !zombieFile.updatedZombieApp()) {
            return null;
        }
        DeployableArtifact artifact = (DeployableArtifact)CollectionUtils.find(this.artifacts, (Predicate)new BeanPropertyValueEqualsPredicate(ARTIFACT_NAME_PROPERTY, (Object)artifactName));
        if (artifact != null) {
            this.deploymentTemplate.preRedeploy(artifact);
            this.undeployArtifact(artifactName);
        }
        Artifact deployedAtifact = this.deployPackagedArtifact(artifactUri);
        this.deploymentTemplate.postRedeploy(deployedAtifact);
        return (T)deployedAtifact;
    }

    private T deployExplodedApp(String addedApp) throws DeploymentException {
        DeployableArtifact artifact;
        if (logger.isInfoEnabled()) {
            logger.info("================== New Exploded Artifact: " + addedApp);
        }
        try {
            artifact = (DeployableArtifact)this.artifactFactory.createArtifact(new File(MuleContainerBootstrapUtils.getMuleAppsDir(), addedApp));
            this.trackArtifact(artifact);
        }
        catch (Throwable t) {
            File artifactDir1 = this.artifactDir;
            File artifactDir = new File(artifactDir1, addedApp);
            this.addZombieFile(addedApp, artifactDir);
            String msg = SplashScreen.miniSplash(String.format("Failed to deploy exploded artifact: '%s', see below", addedApp));
            logger.error(msg, t);
            this.deploymentListener.onDeploymentFailure(addedApp, t);
            if (t instanceof DeploymentException) {
                throw (DeploymentException)t;
            }
            msg = "Failed to deploy artifact: " + addedApp;
            throw new DeploymentException(I18nMessageFactory.createStaticMessage(msg), t);
        }
        this.deployArtifact((T)artifact);
        return (T)artifact;
    }

    @Override
    public void deployArtifact(T artifact) throws DeploymentException {
        try {
            this.trackArtifact(artifact);
            this.deploymentListener.onDeploymentStart(artifact.getArtifactName());
            this.deployer.deploy(artifact);
            this.artifactArchiveInstaller.createAnchorFile(artifact.getArtifactName());
            this.deploymentListener.onDeploymentSuccess(artifact.getArtifactName());
            this.artifactZombieMap.remove(artifact.getArtifactName());
        }
        catch (Throwable t) {
            String msg = SplashScreen.miniSplash(String.format("Failed to deploy artifact '%s', see below", artifact.getArtifactName()));
            logger.error(msg, t);
            this.addZombieApp((Artifact)artifact);
            this.deploymentListener.onDeploymentFailure(artifact.getArtifactName(), t);
            if (t instanceof DeploymentException) {
                throw (DeploymentException)t;
            }
            msg = "Failed to deploy artifact: " + artifact.getArtifactName();
            throw new DeploymentException(I18nMessageFactory.createStaticMessage(msg), t);
        }
    }

    private void addZombieApp(Artifact artifact) {
        File resourceFile = artifact.getResourceFiles()[0];
        if (resourceFile.exists()) {
            try {
                this.artifactZombieMap.put(artifact.getArtifactName(), new ZombieFile(resourceFile));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addZombieFile(String artifactName, File marker) {
        if (marker == null) {
            return;
        }
        if (!marker.exists()) {
            return;
        }
        try {
            this.artifactZombieMap.put(artifactName, new ZombieFile(marker));
        }
        catch (Exception e) {
            logger.debug(String.format("Failed to mark an exploded artifact [%s] as a zombie", marker.getName()), (Throwable)e);
        }
    }

    private T findArtifact(String artifactName) {
        return (T)((DeployableArtifact)CollectionUtils.find(this.artifacts, (Predicate)new BeanPropertyValueEqualsPredicate(ARTIFACT_NAME_PROPERTY, (Object)artifactName)));
    }

    private void trackArtifact(T artifact) {
        this.preTrackArtifact(artifact);
        this.artifacts.add(artifact);
    }

    public void preTrackArtifact(T artifact) {
        T previousArtifact = this.findArtifact(artifact.getArtifactName());
        this.artifacts.remove(previousArtifact);
    }

    private void undeploy(T artifact) {
        this.logRequestToUndeployArtifact(artifact);
        try {
            this.deploymentListener.onUndeploymentStart(artifact.getArtifactName());
            this.artifacts.remove(artifact);
            this.deployer.undeploy(artifact);
            this.artifactArchiveInstaller.desinstallArtifact(artifact.getArtifactName());
            this.deploymentListener.onUndeploymentSuccess(artifact.getArtifactName());
            this.logArtifactUndeployed(artifact);
        }
        catch (RuntimeException e) {
            this.deploymentListener.onUndeploymentFailure(artifact.getArtifactName(), e);
            throw e;
        }
    }

    private void logRequestToUndeployArtifact(T artifact) {
        if (logger.isInfoEnabled()) {
            logger.info("================== Request to Undeploy Artifact: " + artifact.getArtifactName());
        }
    }

    private void logArtifactUndeployed(T artifact) {
        if (logger.isInfoEnabled()) {
            logger.info(SplashScreen.miniSplash(String.format("Undeployed artifact '%s'", artifact.getArtifactName())));
        }
    }

    private T installFrom(URI uri) throws IOException {
        File artifactLocation = this.artifactArchiveInstaller.installArtifact(uri);
        return (T)((DeployableArtifact)this.artifactFactory.createArtifact(artifactLocation));
    }

    @Override
    public void redeploy(T artifact) throws DeploymentException {
        if (logger.isInfoEnabled()) {
            logger.info(SplashScreen.miniSplash(String.format("Redeploying artifact '%s'", artifact.getArtifactName())));
        }
        this.deploymentListener.onUndeploymentStart(artifact.getArtifactName());
        try {
            this.deployer.undeploy(artifact);
            this.deploymentListener.onUndeploymentSuccess(artifact.getArtifactName());
        }
        catch (Throwable e) {
            this.deploymentListener.onUndeploymentFailure(artifact.getArtifactName(), e);
        }
        this.deploymentListener.onDeploymentStart(artifact.getArtifactName());
        try {
            artifact = (DeployableArtifact)this.artifactFactory.createArtifact(artifact.getLocation());
            this.trackArtifact(artifact);
            this.deployer.deploy(artifact);
            this.artifactArchiveInstaller.createAnchorFile(artifact.getArtifactName());
            this.deploymentListener.onDeploymentSuccess(artifact.getArtifactName());
        }
        catch (Throwable t) {
            try {
                this.logDeploymentFailure(t, artifact.getArtifactName());
                this.addZombieApp((Artifact)artifact);
                if (t instanceof DeploymentException) {
                    throw (DeploymentException)t;
                }
                String msg = "Failed to deploy artifact: " + artifact.getArtifactName();
                throw new DeploymentException(I18nMessageFactory.createStaticMessage(msg), t);
            }
            catch (Throwable throwable) {
                this.deploymentListener.onDeploymentFailure(artifact.getArtifactName(), t);
                throw throwable;
            }
        }
        this.artifactZombieMap.remove(artifact.getArtifactName());
    }

    private static class ZombieFile {
        URI uri;
        Long originalTimestamp;
        File file;

        private ZombieFile(File file) {
            this.file = file;
            this.originalTimestamp = file.lastModified();
            this.uri = file.toURI();
        }

        public boolean isFor(URI uri) {
            return this.uri.equals(uri);
        }

        public boolean updatedZombieApp() {
            return this.originalTimestamp.longValue() != this.file.lastModified();
        }

        public boolean exists() {
            return this.file.exists();
        }
    }
}

