/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.util.DeclarationWalker;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.resources.documentation.ExtensionDescriptionsSerializer;
import org.mule.runtime.module.extension.internal.resources.documentation.XmlExtensionDocumentation;
import org.mule.runtime.module.extension.internal.resources.documentation.XmlExtensionElementDocumentation;

public final class ExtensionDescriptionsEnricher
implements DeclarationEnricher {
    private static final ExtensionDescriptionsSerializer serializer = new ExtensionDescriptionsSerializer();

    @Override
    public void enrich(ExtensionLoadingContext loadingContext) {
        String name = ((ExtensionDeclaration)loadingContext.getExtensionDeclarer().getDeclaration()).getName();
        ClassLoader classLoader = loadingContext.getExtensionClassLoader();
        URL resource = classLoader.getResource("META-INF/" + serializer.getFileName(name));
        if (resource != null) {
            try {
                XmlExtensionDocumentation documenter = (XmlExtensionDocumentation)serializer.deserialize(IOUtils.toString((InputStream)resource.openStream()));
                this.document((ExtensionDeclaration)loadingContext.getExtensionDeclarer().getDeclaration(), documenter);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot get descriptions persisted in the extensions-descriptions.xml file", e);
            }
        }
    }

    private void document(ExtensionDeclaration declaration, final XmlExtensionDocumentation documentation) {
        new DeclarationWalker(){

            @Override
            protected void onConfiguration(ConfigurationDeclaration declaration) {
                this.document(declaration, documentation.getConfigs());
            }

            @Override
            protected void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                this.document(declaration, documentation.getOperations());
            }

            @Override
            protected void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                this.document(declaration, documentation.getConnections());
            }

            @Override
            protected void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                this.document(declaration, documentation.getSources());
            }

            private void document(ParameterizedDeclaration<?> declaration, List<XmlExtensionElementDocumentation> elements) {
                elements.stream().filter(e -> e.getName().equals(declaration.getName())).findAny().ifPresent(e -> {
                    declaration.setDescription(e.getDescription());
                    declaration.getAllParameters().forEach(param -> e.getParameters().stream().filter(p -> p.getName().equals(param.getName())).findAny().ifPresent(p -> param.setDescription(p.getDescription())));
                });
            }
        }.walk(declaration);
    }
}

