/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.transformer;

import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.transformer.TransformerUtils;

public class TransformerException
extends MuleException {
    private static final String TRANSFORMER = "Transformer";
    private static final long serialVersionUID = 2943589828020763649L;
    private transient Transformer transformer;

    public TransformerException(I18nMessage message, Transformer transformer) {
        super(message);
        this.transformer = transformer;
        this.addInfo(TRANSFORMER, transformer.toString());
    }

    public TransformerException(I18nMessage message, List<Transformer> transformers) {
        super(message);
        this.transformer = TransformerUtils.firstOrNull(transformers);
        this.addInfo(TRANSFORMER, TransformerUtils.toString(transformers));
    }

    public TransformerException(I18nMessage message, Transformer transformer, Throwable cause) {
        super(message, cause);
        this.transformer = transformer;
        this.addInfo(TRANSFORMER, transformer.toString());
    }

    public TransformerException(I18nMessage message, List<Transformer> transformers, Throwable cause) {
        super(message, cause);
        this.transformer = TransformerUtils.firstOrNull(transformers);
        this.addInfo(TRANSFORMER, TransformerUtils.toString(transformers));
    }

    public TransformerException(Transformer transformer, Throwable cause) {
        super(cause);
        this.transformer = transformer;
        this.addInfo(TRANSFORMER, transformer == null ? "null" : transformer.toString());
    }

    public TransformerException(List<Transformer> transformers, Throwable cause) {
        super(cause);
        this.transformer = TransformerUtils.firstOrNull(transformers);
        this.addInfo(TRANSFORMER, TransformerUtils.toString(transformers));
    }

    public TransformerException(I18nMessage message, Throwable cause) {
        super(message, cause);
    }

    public TransformerException(I18nMessage message) {
        super(message);
    }

    public Transformer getTransformer() {
        return this.transformer;
    }
}

