/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.policy.PolicyPointcut;

public class PolicyParametrization {
    private final String id;
    private final PolicyPointcut pointcut;
    private final Map<String, String> parameters;
    private final int order;
    private final File config;

    public PolicyParametrization(String id, PolicyPointcut pointcut, int order, Map<String, String> parameters, File config) {
        Preconditions.checkArgument(!StringUtils.isEmpty((String)id), "id cannot be null");
        Preconditions.checkArgument(pointcut != null, "pointcut cannot be null");
        Preconditions.checkArgument(parameters != null, "parameters cannot be null");
        Preconditions.checkArgument(order > 0, "order must be positive");
        Preconditions.checkArgument(config != null, "config file cannot be null");
        this.id = id;
        this.pointcut = pointcut;
        this.parameters = Collections.unmodifiableMap(parameters);
        this.order = order;
        this.config = config;
    }

    public String getId() {
        return this.id;
    }

    public PolicyPointcut getPointcut() {
        return this.pointcut;
    }

    public int getOrder() {
        return this.order;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public File getConfig() {
        return this.config;
    }
}

