/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.PoolingProfileTypeBuilder;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.util.XmlModelUtils;
import org.mule.runtime.extension.internal.loader.enricher.InfrastructureDeclarationEnricher;
import org.mule.runtime.extension.internal.property.QNameModelProperty;

public class ConnectionProviderDeclarationEnricher
extends InfrastructureDeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        new IdempotentDeclarationWalker(){

            @Override
            protected void onConnectionProvider(ConnectionProviderDeclaration declaration) {
                ConnectionProviderDeclarationEnricher.this.addReconnectionStrategyParameter(declaration);
                ConnectionManagementType managementType = declaration.getConnectionManagementType();
                if (managementType == ConnectionManagementType.POOLING || managementType == ConnectionManagementType.CACHED) {
                    ConnectionProviderDeclarationEnricher.this.addDisableValidationParameter(declaration, typeLoader);
                }
                if (managementType == ConnectionManagementType.POOLING) {
                    ConnectionProviderDeclarationEnricher.this.addPoolingProfileParameter(declaration);
                }
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private void addPoolingProfileParameter(ConnectionProviderDeclaration declaration) {
        ParameterDeclaration parameter = new ParameterDeclaration("poolingProfile");
        parameter.setDescription("Characteristics of the connection pool");
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.setType(new PoolingProfileTypeBuilder().buildPoolingProfileType(), false);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        parameter.addModelProperty(new QNameModelProperty(XmlModelUtils.MULE_POOLING_PROFILE_TYPE_QNAME));
        this.markAsInfrastructure(parameter);
        declaration.getParameterGroup("Connection").addParameter(parameter);
    }

    private void addDisableValidationParameter(ConnectionProviderDeclaration declaration, ClassTypeLoader typeLoader) {
        ParameterDeclaration parameter = new ParameterDeclaration("disableValidation");
        parameter.setDescription("Disables connection validation");
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.setType(typeLoader.load(Boolean.TYPE), false);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        this.markAsInfrastructure(parameter);
        declaration.getParameterGroup("Connection").addParameter(parameter);
    }
}

