/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.source.SourceResult;

public class SourceCallbacksModelValidator
implements ExtensionModelValidator {
    private static final String SOURCE_RESULT = SourceResult.class.getSimpleName();
    private static final String CALLBACK_CONTEXT = SourceCallbackContext.class.getSimpleName();
    private static final String ERROR_MESSAGE = "'On Terminate Callbacks' can only receive parameters of the following types: '" + SOURCE_RESULT + "' and '" + CALLBACK_CONTEXT + "'";

    @Override
    public void validate(ExtensionModel model, final ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            @Override
            protected void onSource(SourceModel sourceModel) {
                Optional<SourceCallbackModel> terminateCallback;
                Optional<SourceCallbackModel> errorCallback;
                Optional<SourceCallbackModel> successCallback = sourceModel.getSuccessCallback();
                if (SourceCallbacksModelValidator.this.hasCallbacksWithOutOnTerminate(successCallback, errorCallback = sourceModel.getErrorCallback(), terminateCallback = sourceModel.getTerminateCallback()) && (!errorCallback.isPresent() || SourceCallbacksModelValidator.this.hasParameters(errorCallback))) {
                    problemsReporter.addError(new Problem(sourceModel, SourceCallbacksModelValidator.this.getMissingTerminateCallbackError(sourceModel)));
                }
                terminateCallback.ifPresent(callback -> {
                    List<ParameterModel> parameters = callback.getAllParameterModels();
                    if (!parameters.isEmpty()) {
                        StringJoiner joiner = new StringJoiner(",", "[", "]");
                        parameters.forEach(param -> joiner.add(param.getName()));
                        problemsReporter.addError(new Problem(sourceModel, String.format(ERROR_MESSAGE + ". Offending parameters: %s", joiner.toString())));
                    }
                });
                this.stop();
            }
        }.walk(model);
    }

    private boolean hasCallbacksWithOutOnTerminate(Optional<SourceCallbackModel> successCallback, Optional<SourceCallbackModel> errorCallback, Optional<SourceCallbackModel> terminateCallback) {
        return (successCallback.isPresent() || errorCallback.isPresent()) && !terminateCallback.isPresent();
    }

    private boolean hasParameters(Optional<SourceCallbackModel> errorCallback) {
        return errorCallback.isPresent() && !errorCallback.get().getAllParameterModels().isEmpty();
    }

    private String getMissingTerminateCallbackError(SourceModel sourceModel) {
        return "The source [" + sourceModel.getName() + "] defines a Success or Error Callback. If at least one of these are defined, a Terminate Callback should also be defined.";
    }
}

