/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.source;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.retry.RetryPolicyTemplate;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.streaming.CursorProviderFactory;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionMessageSource;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapterFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConfigurer;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class ExtensionSourceObjectFactory
extends AbstractExtensionObjectFactory<ExtensionMessageSource> {
    private final ExtensionModel extensionModel;
    private final SourceModel sourceModel;
    private ConfigurationProvider configurationProvider;
    private RetryPolicyTemplate retryPolicyTemplate;
    private CursorProviderFactory cursorProviderFactory;
    @Inject
    private ConnectionManagerAdapter connectionManager;

    public ExtensionSourceObjectFactory(ExtensionModel extensionModel, SourceModel sourceModel, MuleContext muleContext) {
        super(muleContext);
        this.extensionModel = extensionModel;
        this.sourceModel = sourceModel;
    }

    @Override
    protected ParametersResolver getParametersResolver(MuleContext muleContext) {
        return ParametersResolver.fromValues(this.parameters, muleContext);
    }

    @Override
    public ExtensionMessageSource doGetObject() throws ConfigurationException, InitialisationException {
        return ClassUtils.withContextClassLoader(MuleExtensionUtils.getClassLoader(this.extensionModel), () -> {
            this.parametersResolver.checkParameterGroupExclusiveness(this.sourceModel, this.parameters.keySet());
            ResolverSet nonCallbackParameters = this.getNonCallbackParameters();
            if (nonCallbackParameters.isDynamic()) {
                throw this.dynamicParameterException(nonCallbackParameters, this.sourceModel);
            }
            ResolverSet responseCallbackParameters = this.getCallbackParameters(this.sourceModel.getSuccessCallback());
            ResolverSet errorCallbackParameters = this.getCallbackParameters(this.sourceModel.getErrorCallback());
            ResolverSet terminateCallbackParameters = this.getCallbackParameters(this.sourceModel.getTerminateCallback());
            LifecycleUtils.initialiseIfNeeded((Object)nonCallbackParameters, true, this.muleContext);
            LifecycleUtils.initialiseIfNeeded((Object)responseCallbackParameters, true, this.muleContext);
            LifecycleUtils.initialiseIfNeeded((Object)errorCallbackParameters, true, this.muleContext);
            return new ExtensionMessageSource(this.extensionModel, this.sourceModel, this.getSourceFactory(nonCallbackParameters, responseCallbackParameters, errorCallbackParameters, terminateCallbackParameters), this.configurationProvider, this.getRetryPolicyTemplate(), this.cursorProviderFactory, this.muleContext.getExtensionManager());
        });
    }

    private ResolverSet getNonCallbackParameters() throws ConfigurationException {
        return this.parametersResolver.getParametersAsResolverSet(this.muleContext, this.sourceModel, this.sourceModel.getParameterGroupModels());
    }

    private ResolverSet getCallbackParameters(Optional<SourceCallbackModel> callbackModel) throws ConfigurationException {
        if (callbackModel.isPresent()) {
            return this.parametersResolver.getParametersAsResolverSet(callbackModel.get(), this.muleContext);
        }
        return new ResolverSet(this.muleContext);
    }

    private SourceAdapterFactory getSourceFactory(ResolverSet nonCallbackParameters, ResolverSet successCallbackParameters, ResolverSet errorCallbackParameters, ResolverSet terminateCallbackParameters) {
        return (configurationInstance, sourceCallbackFactory) -> {
            Source source = MuleExtensionUtils.getSourceFactory(this.sourceModel).createSource();
            try {
                source = new SourceConfigurer(this.sourceModel, nonCallbackParameters, this.muleContext).configure(source, configurationInstance);
                return new SourceAdapter(this.extensionModel, this.sourceModel, source, configurationInstance, this.cursorProviderFactory, sourceCallbackFactory, nonCallbackParameters, successCallbackParameters, terminateCallbackParameters, errorCallbackParameters);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Could not create generator for source '%s'", this.sourceModel.getName())), (Throwable)e);
            }
        };
    }

    private RetryPolicyTemplate getRetryPolicyTemplate() throws ConfigurationException {
        return this.retryPolicyTemplate != null ? this.retryPolicyTemplate : this.connectionManager.getDefaultRetryPolicyTemplate();
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    private ConfigurationException dynamicParameterException(ResolverSet resolverSet, SourceModel model) {
        List dynamicParams = resolverSet.getResolvers().entrySet().stream().filter(entry -> ((ValueResolver)entry.getValue()).isDynamic()).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        return new ConfigurationException(I18nMessageFactory.createStaticMessage(String.format("The '%s' message source is using expressions, which are not allowed on message sources. Offending parameters are: [%s]", model.getName(), Joiner.on((char)',').join(dynamicParams))));
    }

    public void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    public void setCursorProviderFactory(CursorProviderFactory cursorProviderFactory) {
        this.cursorProviderFactory = cursorProviderFactory;
    }
}

