/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.generic;

import org.mule.runtime.config.spring.parsers.assembly.BeanAssembler;
import org.mule.runtime.config.spring.parsers.generic.ChildDefinitionParser;
import org.mule.runtime.core.api.util.StringUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TextDefinitionParser
extends ChildDefinitionParser {
    private boolean requireCdata = false;

    public TextDefinitionParser(String setterMethod) {
        super(setterMethod, String.class);
    }

    public TextDefinitionParser(String setterMethod, boolean requireCdata) {
        super(setterMethod, String.class);
        this.requireCdata = requireCdata;
    }

    @Override
    protected void postProcess(ParserContext context, BeanAssembler assembler, Element element) {
        String value;
        Node node = element.getFirstChild();
        if (this.requireCdata && node.getNodeType() != 4) {
            if ((node = node.getNextSibling()) == null) {
                throw new IllegalArgumentException("No CDATA node found in " + element.getNodeName());
            }
            if (node.getNodeType() != 4) {
                throw new IllegalArgumentException("Sibling node is not a CDATA section, but one should be defined. Elements is " + element.getNodeName());
            }
        }
        if (node != null && !StringUtils.isBlank(value = node.getNodeValue())) {
            this.addPropertyValue(value, assembler.getTarget().getPropertyValues());
        }
    }

    protected void addPropertyValue(String value, MutablePropertyValues tempPropertyValues) {
        tempPropertyValues.addPropertyValue(this.setterMethod, (Object)value);
    }
}

