/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.specific;

import org.mule.runtime.config.spring.parsers.specific.DataTypeFactoryBean;
import org.mule.runtime.config.spring.parsers.specific.MessageProcessorDefinitionParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class MessageProcessorWithDataTypeDefinitionParser
extends MessageProcessorDefinitionParser {
    private static final String ENCODING = "encoding";
    private static final String MIME_TYPE = "mimeType";

    public MessageProcessorWithDataTypeDefinitionParser(Class messageProcessor) {
        super(messageProcessor);
    }

    public MessageProcessorWithDataTypeDefinitionParser() {
    }

    protected void removeDataTypeProperties(MutablePropertyValues props) {
        props.removePropertyValue(MIME_TYPE);
        props.removePropertyValue(ENCODING);
    }

    @Override
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        AbstractBeanDefinition abstractBeanDefinition = super.parseInternal(element, parserContext);
        MutablePropertyValues props = abstractBeanDefinition.getPropertyValues();
        AbstractBeanDefinition dataTypeBeanDefinition = this.parseDataType((PropertyValues)props);
        if (dataTypeBeanDefinition != null) {
            props.add("returnDataType", (Object)dataTypeBeanDefinition);
            this.removeDataTypeProperties(props);
        }
        return abstractBeanDefinition;
    }

    protected AbstractBeanDefinition parseDataType(PropertyValues sourceProperties) {
        if (this.isDataTypeConfigured(sourceProperties)) {
            return DataTypeFactoryBean.buildDataTypeDefinition(Object.class.getName(), sourceProperties);
        }
        return null;
    }

    protected boolean isDataTypeConfigured(PropertyValues sourceProperties) {
        return sourceProperties.contains(ENCODING) || sourceProperties.contains(MIME_TYPE);
    }
}

