/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.lifecycle;

import java.util.Collection;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.slf4j.Logger;

public class LifecycleUtils {
    private LifecycleUtils() {
    }

    public static void initialiseIfNeeded(Object object) throws InitialisationException {
        if ((object = LifecycleUtils.unwrap(object)) instanceof Initialisable) {
            ((Initialisable)object).initialise();
        }
    }

    public static void initialiseIfNeeded(Object object, MuleContext muleContext, FlowConstruct flowConstruct) throws InitialisationException {
        object = LifecycleUtils.unwrap(object);
        if (flowConstruct != null && object instanceof FlowConstructAware) {
            ((FlowConstructAware)object).setFlowConstruct(flowConstruct);
        }
        LifecycleUtils.initialiseIfNeeded(object, muleContext);
    }

    public static void initialiseIfNeeded(Object object, MuleContext muleContext) throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(object, false, muleContext);
    }

    public static void initialiseIfNeeded(Object object, boolean inject, MuleContext muleContext) throws InitialisationException {
        Preconditions.checkArgument(muleContext != null, "muleContext cannot be null");
        object = LifecycleUtils.unwrap(object);
        if (object == null) {
            return;
        }
        if (object instanceof MuleContextAware) {
            ((MuleContextAware)object).setMuleContext(muleContext);
        }
        if (inject) {
            try {
                muleContext.getInjector().inject(object);
            }
            catch (MuleException e) {
                I18nMessage message = I18nMessageFactory.createStaticMessage(String.format("Found exception trying to inject object of type '%s' on initialising phase", object.getClass().getName()));
                if (object instanceof Initialisable) {
                    throw new InitialisationException(message, (Throwable)e, (Initialisable)object);
                }
                throw new MuleRuntimeException(message, (Throwable)e);
            }
        }
        LifecycleUtils.initialiseIfNeeded(object);
    }

    public static void initialiseIfNeeded(Collection<? extends Object> objects) throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(objects, null);
    }

    public static void initialiseIfNeeded(Collection<? extends Object> objects, MuleContext muleContext) throws InitialisationException {
        try {
            LifecycleUtils.doApplyPhase("initialise", objects, muleContext, null);
        }
        catch (MuleException e) {
            throw (InitialisationException)e;
        }
    }

    public static void initialiseIfNeeded(Collection<? extends Object> objects, boolean inject, MuleContext muleContext) throws InitialisationException {
        for (Object object : objects) {
            LifecycleUtils.initialiseIfNeeded(object, inject, muleContext);
        }
    }

    public static void startIfNeeded(Object object) throws MuleException {
        if ((object = LifecycleUtils.unwrap(object)) instanceof Startable) {
            ((Startable)object).start();
        }
    }

    public static void startIfNeeded(Collection<? extends Object> objects) throws MuleException {
        LifecycleUtils.doApplyPhase("start", objects, null, null);
    }

    public static void stopIfNeeded(Collection<? extends Object> objects) throws MuleException {
        LifecycleUtils.doApplyPhase("stop", objects, null, null);
    }

    public static void safeStopIfNeeded(Collection<? extends Object> objects, Logger logger) {
        try {
            LifecycleUtils.doApplyPhase("stop", objects, null, logger);
        }
        catch (Exception e) {
            logger.warn("Found unexpected exception during safe stop", (Throwable)e);
        }
    }

    public static void stopIfNeeded(Object object) throws MuleException {
        if ((object = LifecycleUtils.unwrap(object)) instanceof Stoppable) {
            ((Stoppable)object).stop();
        }
    }

    public static void disposeIfNeeded(Object object, Logger logger) {
        if ((object = LifecycleUtils.unwrap(object)) instanceof Disposable) {
            try {
                ((Disposable)object).dispose();
            }
            catch (Exception e) {
                logger.error("Exception found trying to dispose object. Shutdown will continue", (Throwable)e);
            }
        }
    }

    public static void disposeIfNeeded(Collection<? extends Object> objects, Logger logger) {
        try {
            LifecycleUtils.doApplyPhase("dispose", objects, null, logger);
        }
        catch (Exception e) {
            logger.error("Exception found trying to dispose object. Shutdown will continue", (Throwable)e);
        }
    }

    public static void assertNotStopping(MuleContext muleContext, String errorMessage) {
        if (muleContext.isStopped() || muleContext.isStopping()) {
            throw new IllegalStateException(errorMessage);
        }
    }

    public static void setFlowConstructIfNeeded(Object object, FlowConstruct flowConstruct) {
        if ((object = LifecycleUtils.unwrap(object)) != null && object instanceof FlowConstructAware) {
            ((FlowConstructAware)object).setFlowConstruct(flowConstruct);
        }
    }

    public static void setFlowConstructIfNeeded(Collection<? extends Object> objects, FlowConstruct flowConstruct) {
        objects.forEach(o -> LifecycleUtils.setFlowConstructIfNeeded(o, flowConstruct));
    }

    public static void setMuleContextIfNeeded(Object object, MuleContext muleContext) {
        if ((object = LifecycleUtils.unwrap(object)) != null && object instanceof MuleContextAware) {
            ((MuleContextAware)object).setMuleContext(muleContext);
        }
    }

    public static void setMuleContextIfNeeded(Collection<? extends Object> objects, MuleContext muleContext) {
        objects.forEach(o -> LifecycleUtils.setMuleContextIfNeeded(o, muleContext));
    }

    private static void doApplyPhase(String phase, Collection<? extends Object> objects, MuleContext muleContext, Logger logger) throws MuleException {
        if (CollectionUtils.isEmpty(objects)) {
            return;
        }
        for (Object object : objects) {
            Object object2 = LifecycleUtils.unwrap(object);
            if (object2 == null) continue;
            try {
                if ("initialise".equals(phase)) {
                    if (muleContext != null) {
                        LifecycleUtils.initialiseIfNeeded(object2, muleContext);
                        continue;
                    }
                    LifecycleUtils.initialiseIfNeeded(object2);
                    continue;
                }
                if ("start".equals(phase)) {
                    LifecycleUtils.startIfNeeded(object2);
                    continue;
                }
                if ("stop".equals(phase)) {
                    LifecycleUtils.stopIfNeeded(object2);
                    continue;
                }
                if (!"dispose".equals(phase) || !(object2 instanceof Disposable)) continue;
                LifecycleUtils.disposeIfNeeded(object2, logger);
            }
            catch (MuleException e) {
                if (logger != null) {
                    logger.error(String.format("Could not apply %s phase on object of class %s", phase, object2.getClass().getName()), (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
    }

    private static Object unwrap(Object value) {
        if (value instanceof Optional) {
            Optional optional = (Optional)value;
            return optional.isPresent() ? optional.get() : null;
        }
        return value;
    }
}

