/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.execution;

import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.MessageProcessorExecutionInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionToMessagingExceptionExecutionInterceptor
implements MessageProcessorExecutionInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionToMessagingExceptionExecutionInterceptor.class);
    private MuleContext muleContext;
    private FlowConstruct flowConstruct;

    @Override
    public Event execute(Processor messageProcessor, Event event) throws MessagingException {
        try {
            return messageProcessor.process(event);
        }
        catch (Exception exception) {
            MessagingException messagingException = exception instanceof MessagingException ? (MessagingException)exception : new MessagingException(event, exception, messageProcessor);
            throw ExceptionUtils.updateMessagingException(LOGGER, messageProcessor, messagingException, this.muleContext.getErrorTypeLocator(), this.muleContext.getErrorTypeRepository(), this.flowConstruct, this.muleContext);
        }
        catch (Throwable ex) {
            throw ExceptionUtils.putContext(new MessagingException(event, ex, messageProcessor), messageProcessor, event, this.flowConstruct, this.muleContext);
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }
}

