/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.execution;

import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.message.ErrorBuilder;

public final class SourceErrorException
extends MuleRuntimeException {
    private static final long serialVersionUID = 160215774280116876L;
    private Event event;
    private ErrorType errorType;
    private MessagingException originalCause;

    public SourceErrorException(Event event, ErrorType errorType, Throwable cause) {
        super(cause);
        this.event = event;
        this.errorType = errorType;
        this.originalCause = null;
    }

    public SourceErrorException(Event event, ErrorType errorType, Throwable cause, MessagingException originalCause) {
        super(cause);
        this.event = event;
        this.errorType = errorType;
        this.originalCause = originalCause;
    }

    public Event getEvent() {
        return this.event;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public Optional<MessagingException> getOriginalCause() {
        return Optional.ofNullable(this.originalCause);
    }

    public MessagingException toMessagingException() {
        return new MessagingException(Event.builder(this.getEvent()).error(ErrorBuilder.builder(this.getCause()).errorType(this.getErrorType()).build()).build(), this.getCause());
    }
}

