/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.classloader;

import java.util.HashSet;
import java.util.Set;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.classloader.ClassLoaderFilterFactory;
import org.mule.runtime.module.artifact.classloader.DefaultArtifactClassLoaderFilter;

public class ArtifactClassLoaderFilterFactory
implements ClassLoaderFilterFactory {
    private static final String PACKAGE_SEPARATOR = "/";

    @Override
    public ArtifactClassLoaderFilter create(String exportedClassPackages, String exportedResources) {
        Set<String> exportedArtifactPackages = ArtifactClassLoaderFilterFactory.parseExportedResource(exportedClassPackages);
        Set<String> exportedArtifactResources = ArtifactClassLoaderFilterFactory.parseExportedResource(exportedResources);
        if (exportedArtifactPackages.isEmpty() && exportedArtifactResources.isEmpty()) {
            return DefaultArtifactClassLoaderFilter.NULL_CLASSLOADER_FILTER;
        }
        return new DefaultArtifactClassLoaderFilter(exportedArtifactPackages, exportedArtifactResources);
    }

    public static Set<String> parseExportedResource(String exportedPackages) {
        HashSet<String> exported = new HashSet<String>();
        if (!StringUtils.isBlank(exportedPackages)) {
            String[] exports;
            for (String export : exports = exportedPackages.split(",")) {
                if ((export = export.trim()).startsWith(PACKAGE_SEPARATOR)) {
                    export = export.substring(1);
                }
                if (export.endsWith(PACKAGE_SEPARATOR)) {
                    export = export.substring(0, export.length() - 1);
                }
                exported.add(export);
            }
        }
        return exported;
    }
}

