/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.descriptor;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.descriptor.BundleDependency;

public class ClassLoaderModel {
    public static final ClassLoaderModel NULL_CLASSLOADER_MODEL = new ClassLoaderModel(new URL[0], new HashSet<String>(), new HashSet<String>(), new HashSet<BundleDependency>());
    private final URL[] urls;
    private final Set<String> exportedPackages;
    private final Set<String> exportedResources;
    private final Set<BundleDependency> dependencies;

    private ClassLoaderModel(URL[] urls, Set<String> exportedPackages, Set<String> exportedResources, Set<BundleDependency> dependencies) {
        this.urls = urls;
        this.exportedPackages = exportedPackages;
        this.exportedResources = exportedResources;
        this.dependencies = dependencies;
    }

    public URL[] getUrls() {
        return this.urls;
    }

    public Set<String> getExportedPackages() {
        return this.exportedPackages;
    }

    public Set<String> getExportedResources() {
        return this.exportedResources;
    }

    public Set<BundleDependency> getDependencies() {
        return this.dependencies;
    }

    public static class ClassLoaderModelBuilder {
        private Set<String> packages = new HashSet<String>();
        private Set<String> resources = new HashSet<String>();
        private List<URL> urls = new ArrayList<URL>();
        private Set<BundleDependency> dependencies = new HashSet<BundleDependency>();

        public ClassLoaderModelBuilder() {
        }

        public ClassLoaderModelBuilder(ClassLoaderModel source) {
            Preconditions.checkArgument(source != null, "source cannot be null");
            this.packages.addAll(source.exportedPackages);
            this.resources.addAll(source.exportedResources);
            this.urls = new ArrayList<URL>(Arrays.asList(source.urls));
            this.dependencies.addAll(source.dependencies);
        }

        public ClassLoaderModelBuilder exportingPackages(Set<String> packages) {
            Preconditions.checkArgument(packages != null, "packages cannot be null");
            this.packages.addAll(packages);
            return this;
        }

        public ClassLoaderModelBuilder exportingResources(Set<String> resources) {
            Preconditions.checkArgument(resources != null, "resources cannot be null");
            this.resources.addAll(resources);
            return this;
        }

        public ClassLoaderModelBuilder dependingOn(Set<BundleDependency> dependencies) {
            Preconditions.checkArgument(dependencies != null, "dependencies cannot be null");
            this.dependencies.addAll(dependencies);
            return this;
        }

        public ClassLoaderModelBuilder containing(URL url) {
            Preconditions.checkArgument(url != null, "url cannot be null");
            this.urls.add(url);
            return this;
        }

        public ClassLoaderModel build() {
            return new ClassLoaderModel(this.urls.toArray(new URL[0]), this.packages, this.resources, this.dependencies);
        }
    }
}

