/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jgrapht.Graph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.internal.loader.enricher.ModuleErrors;

public class ErrorsModelFactory {
    private static final String MULE = "mule".toUpperCase();
    private final String extensionNamespace;
    private final Map<String, ErrorModel> errorModelMap;

    public ErrorsModelFactory(ErrorTypeDefinition<?>[] errorTypesEnum, String extensionNamespace) throws IllegalModelDefinitionException {
        this.extensionNamespace = extensionNamespace.toUpperCase();
        DefaultDirectedGraph<ErrorTypeDefinition, Pair<ErrorTypeDefinition, ErrorTypeDefinition>> graph = this.toGraph(errorTypesEnum);
        this.errorModelMap = new HashMap<String, ErrorModel>();
        this.initErrorModelMap(this.errorModelMap);
        new TopologicalOrderIterator(graph).forEachRemaining(errorType -> {
            ErrorModel errorModel = this.toErrorModel((ErrorTypeDefinition<?>)errorType, this.errorModelMap);
            this.errorModelMap.put(errorModel.toString(), errorModel);
        });
        this.addConnectivityErrors(this.errorModelMap);
    }

    public ErrorsModelFactory(String extensionNamespace) throws IllegalModelDefinitionException {
        this.extensionNamespace = extensionNamespace.toUpperCase();
        this.errorModelMap = new HashMap<String, ErrorModel>();
        this.initErrorModelMap(this.errorModelMap);
        this.addConnectivityErrors(this.errorModelMap);
    }

    public Set<ErrorModel> getErrorModels() {
        return new HashSet<ErrorModel>(this.errorModelMap.values());
    }

    ErrorModel getErrorModel(ErrorTypeDefinition errorTypeDefinition) {
        return this.errorModelMap.get(this.toIdentifier(errorTypeDefinition));
    }

    private DefaultDirectedGraph<ErrorTypeDefinition, Pair<ErrorTypeDefinition, ErrorTypeDefinition>> toGraph(ErrorTypeDefinition<?>[] errorTypesEnum) {
        DefaultDirectedWeightedGraph graph = new DefaultDirectedWeightedGraph(ImmutablePair::new);
        Stream.of(errorTypesEnum).forEach(arg_0 -> this.lambda$toGraph$1((DefaultDirectedGraph)graph, arg_0));
        this.detectCycleReferences((DefaultDirectedGraph<?, ?>)graph);
        return graph;
    }

    private ErrorModel toErrorModel(ErrorTypeDefinition<?> errorTypeDefinition, Map<String, ErrorModel> errorModelMap) {
        if (errorModelMap.containsKey(this.toIdentifier(errorTypeDefinition))) {
            return errorModelMap.get(this.toIdentifier(errorTypeDefinition));
        }
        ErrorModelBuilder builder = ErrorModelBuilder.newError(errorTypeDefinition.getType(), this.getErrorNamespace(errorTypeDefinition));
        builder.withParent(this.toErrorModel(errorTypeDefinition.getParent().orElse(ModuleErrors.ANY), errorModelMap));
        ErrorModel errorModel = builder.build();
        errorModelMap.put(this.toIdentifier(errorTypeDefinition), errorModel);
        return errorModel;
    }

    private String toIdentifier(ErrorTypeDefinition errorTypeDefinition) {
        return this.getErrorNamespace(errorTypeDefinition) + ":" + errorTypeDefinition.getType();
    }

    private String getErrorNamespace(ErrorTypeDefinition errorType) {
        return errorType instanceof MuleErrors ? MULE : this.extensionNamespace;
    }

    private void addType(ErrorTypeDefinition<?> errorType, Graph<ErrorTypeDefinition, Pair<ErrorTypeDefinition, ErrorTypeDefinition>> graph) {
        graph.addVertex(errorType);
        ErrorTypeDefinition parentErrorType = errorType.getParent().orElse(ModuleErrors.ANY);
        graph.addVertex((Object)parentErrorType);
        graph.addEdge(errorType, (Object)parentErrorType);
    }

    private void detectCycleReferences(DefaultDirectedGraph<?, ?> graph) {
        CycleDetector cycleDetector = new CycleDetector(graph);
        if (cycleDetector.detectCycles()) {
            throw new IllegalModelDefinitionException("Cyclic Error Types reference detected, offending types: " + cycleDetector.findCycles());
        }
    }

    private void addConnectivityErrors(Map<String, ErrorModel> errorModelMap) {
        ErrorModel retryExhaustedError;
        String retry;
        ErrorModel connectivityError = this.toErrorModel(ModuleErrors.CONNECTIVITY, errorModelMap);
        String key = connectivityError.toString();
        if (!errorModelMap.containsKey(key)) {
            errorModelMap.put(key, connectivityError);
        }
        if (!errorModelMap.containsKey(retry = (retryExhaustedError = this.toErrorModel(ModuleErrors.RETRY_EXHAUSTED, errorModelMap)).toString())) {
            errorModelMap.put(retry, retryExhaustedError);
        }
    }

    private void initErrorModelMap(Map<String, ErrorModel> errorModelMap) {
        errorModelMap.put(this.toIdentifier(MuleErrors.ANY), ErrorModelBuilder.newError(MuleErrors.ANY.getType(), MULE).build());
    }

    private /* synthetic */ void lambda$toGraph$1(DefaultDirectedGraph graph, ErrorTypeDefinition error) {
        this.addType(error, (Graph<ErrorTypeDefinition, Pair<ErrorTypeDefinition, ErrorTypeDefinition>>)graph);
    }
}

