/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.transaction;

import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.tx.Transactional;

public class ExtensionTransactionalResource<T extends TransactionalConnection>
implements Transactional {
    private final T connection;
    private final ConnectionHandler<T> connectionHandler;
    private final Transaction transaction;

    public ExtensionTransactionalResource(T connection, ConnectionHandler<T> connectionHandler, Transaction transaction) {
        this.connection = connection;
        this.connectionHandler = connectionHandler;
        this.transaction = transaction;
    }

    @Override
    public void begin() throws Exception {
        this.connection.begin();
    }

    @Override
    public void commit() throws Exception {
        try {
            this.connection.commit();
        }
        finally {
            this.connectionHandler.release();
        }
    }

    @Override
    public void rollback() throws Exception {
        try {
            this.connection.rollback();
        }
        finally {
            this.connectionHandler.release();
        }
    }

    public boolean isTransactionResolved() throws TransactionException {
        return this.transaction.isCommitted() || this.transaction.isRolledBack();
    }

    public T getConnection() {
        return this.connection;
    }

    public ConnectionHandler<T> getConnectionHandler() {
        return this.connectionHandler;
    }
}

