/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.processor;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.spring.dsl.processor.ConfigLineProvider;
import org.mule.runtime.config.spring.dsl.processor.SimpleConfigAttribute;
import org.w3c.dom.Node;

public class ConfigLine {
    private ConfigLineProvider parent;
    private String namespace;
    private String identifier;
    private Map<String, SimpleConfigAttribute> configAttributes = new HashMap<String, SimpleConfigAttribute>();
    private Map<String, Object> customAttributes = new HashMap<String, Object>();
    private List<ConfigLine> childrenConfigLines = new LinkedList<ConfigLine>();
    private int lineNumber;
    private Node node;
    private String textContent;

    public String getNamespace() {
        return this.namespace;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Map<String, SimpleConfigAttribute> getConfigAttributes() {
        return ImmutableMap.copyOf(this.configAttributes);
    }

    public Map<String, Object> getCustomAttributes() {
        return Collections.unmodifiableMap(this.customAttributes);
    }

    public List<ConfigLine> getChildren() {
        return this.childrenConfigLines;
    }

    public ConfigLine getParent() {
        return this.parent.getConfigLine();
    }

    public Node getNode() {
        return this.node;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigLine that = (ConfigLine)o;
        if (this.parent != null ? !this.parent.equals(that.parent) : that.parent != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.identifier != null ? !this.identifier.equals(that.identifier) : that.identifier != null) {
            return false;
        }
        if (this.configAttributes != null ? !this.configAttributes.equals(that.configAttributes) : that.configAttributes != null) {
            return false;
        }
        return this.childrenConfigLines != null ? this.childrenConfigLines.equals(that.childrenConfigLines) : that.childrenConfigLines == null;
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        result = 31 * result + (this.configAttributes != null ? this.configAttributes.hashCode() : 0);
        result = 31 * result + (this.childrenConfigLines != null ? this.childrenConfigLines.hashCode() : 0);
        return result;
    }

    public static class Builder {
        public static final String BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT = "builder already build an object, you cannot modify it";
        private ConfigLine configLine = new ConfigLine();
        private boolean alreadyBuild;

        public Builder setNamespace(String namespace) {
            Preconditions.checkState(!this.alreadyBuild, BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT);
            this.configLine.namespace = namespace;
            return this;
        }

        public Builder setIdentifier(String operation) {
            Preconditions.checkState(!this.alreadyBuild, BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT);
            this.configLine.identifier = operation;
            return this;
        }

        public Builder setLineNumber(int lineNumber) {
            Preconditions.checkState(!this.alreadyBuild, BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT);
            this.configLine.lineNumber = lineNumber;
            return this;
        }

        public Builder addConfigAttribute(String name, String value, boolean valueFromSchema) {
            Preconditions.checkState(!this.alreadyBuild, BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT);
            this.configLine.configAttributes.put(name, new SimpleConfigAttribute(name, value, valueFromSchema));
            return this;
        }

        public Builder addCustomAttribute(String name, Object value) {
            Preconditions.checkState(!this.alreadyBuild, BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT);
            this.configLine.customAttributes.put(name, value);
            return this;
        }

        public Builder addChild(ConfigLine line) {
            Preconditions.checkState(!this.alreadyBuild, BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT);
            this.configLine.childrenConfigLines.add(line);
            return this;
        }

        public Builder setParent(ConfigLineProvider parent) {
            Preconditions.checkState(!this.alreadyBuild, BUILDER_ALREADY_BUILD_AN_OBJECT_YOU_CANNOT_MODIFY_IT);
            this.configLine.parent = parent;
            return this;
        }

        public Builder setNode(Node node) {
            this.configLine.node = node;
            return this;
        }

        public Builder setTextContent(String textContent) {
            this.configLine.textContent = textContent;
            return this;
        }

        public ConfigLine build() {
            this.alreadyBuild = true;
            return this.configLine;
        }
    }
}

