/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.exception;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.EnrichedNotificationInfo;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.context.notification.ErrorHandlerNotification;
import org.mule.runtime.core.exception.AbstractExceptionListener;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.internal.message.DefaultExceptionPayload;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.management.stats.FlowConstructStatistics;

public abstract class AbstractMessagingExceptionStrategy
extends AbstractExceptionListener
implements MessagingExceptionHandler {
    private boolean stopMessageProcessing;

    public AbstractMessagingExceptionStrategy() {
    }

    public AbstractMessagingExceptionStrategy(MuleContext muleContext) {
        this.setMuleContext(muleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Event handleException(MessagingException ex, Event event) {
        try {
            this.muleContext.getNotificationManager().fireNotification(new ErrorHandlerNotification(EnrichedNotificationInfo.createInfo(event, ex, null), this.flowConstruct, 2001));
            this.fireNotification(ex, event);
            this.logException(ex, event);
            event = this.doHandleException(ex, event);
            DefaultExceptionPayload exceptionPayload = new DefaultExceptionPayload(ex);
            if (Event.getCurrentEvent() != null) {
                Event currentEvent = Event.getCurrentEvent();
                currentEvent = Event.builder(currentEvent).message(InternalMessage.builder(currentEvent.getMessage()).exceptionPayload(exceptionPayload).build()).build();
                Event.setCurrentEvent(currentEvent);
            }
            Event event2 = Event.builder(event).message(InternalMessage.builder(event.getMessage()).nullPayload().exceptionPayload(exceptionPayload).build()).build();
            return event2;
        }
        finally {
            this.muleContext.getNotificationManager().fireNotification(new ErrorHandlerNotification(EnrichedNotificationInfo.createInfo(event, ex, null), this.flowConstruct, 2002));
        }
    }

    protected Event doHandleException(Exception ex, Event event) {
        Event result;
        FlowConstructStatistics statistics = this.flowConstruct.getStatistics();
        if (statistics != null && statistics.isEnabled()) {
            statistics.incExecutionError();
        }
        this.defaultHandler(ex);
        if (this.isRollback(ex)) {
            this.logger.debug("Rolling back transaction");
            this.rollback(ex);
            this.logger.debug("Routing exception message");
            result = this.routeException(event, this.flowConstruct, ex);
        } else {
            this.logger.debug("Routing exception message");
            result = this.routeException(event, this.flowConstruct, ex);
        }
        this.closeStream(event.getMessage());
        if (this.stopMessageProcessing) {
            this.stopFlow();
        }
        return result;
    }

    protected void stopFlow() {
        if (this.flowConstruct instanceof Stoppable) {
            this.logger.info("Stopping flow '" + this.flowConstruct.getName() + "' due to exception");
            try {
                ((Lifecycle)((Object)this.flowConstruct)).stop();
            }
            catch (MuleException e) {
                this.logger.error("Unable to stop flow '" + this.flowConstruct.getName() + "'", (Throwable)e);
            }
        } else {
            this.logger.warn("Flow is not stoppable");
        }
    }

    public boolean isStopMessageProcessing() {
        return this.stopMessageProcessing;
    }

    public void setStopMessageProcessing(boolean stopMessageProcessing) {
        this.stopMessageProcessing = stopMessageProcessing;
    }

    @Deprecated
    protected void defaultHandler(Throwable t) {
    }
}

