/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.routing.UntilSuccessfulConfiguration;
import org.mule.runtime.core.routing.UntilSuccessfulProcessingStrategy;

public abstract class AbstractUntilSuccessfulProcessingStrategy
implements UntilSuccessfulProcessingStrategy,
MuleContextAware {
    private UntilSuccessfulConfiguration untilSuccessfulConfiguration;
    protected MuleContext muleContext;

    @Override
    public void setUntilSuccessfulConfiguration(UntilSuccessfulConfiguration untilSuccessfulConfiguration) {
        this.untilSuccessfulConfiguration = untilSuccessfulConfiguration;
    }

    protected Event processEvent(Event event) {
        Event returnEvent;
        try {
            returnEvent = this.untilSuccessfulConfiguration.getRoute().process(event);
        }
        catch (MuleException me) {
            throw new MuleRuntimeException(me);
        }
        if (returnEvent == null) {
            return returnEvent;
        }
        Message msg = returnEvent.getMessage();
        if (msg == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("No message found in response to processing, which is therefore considered failed for event: " + event));
        }
        Event.Builder builder = Event.builder(returnEvent);
        boolean errorDetected = this.untilSuccessfulConfiguration.getFailureExpressionFilter().accept(returnEvent, builder);
        if (errorDetected) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Failure expression positive when processing event: " + event));
        }
        return builder.build();
    }

    protected Event processResponseThroughAckResponseExpression(Event event) {
        if (event == null) {
            return null;
        }
        String ackExpression = this.getUntilSuccessfulConfiguration().getAckExpression();
        if (ackExpression == null) {
            return event;
        }
        return Event.builder(event).message(Message.builder(event.getMessage()).payload(this.getUntilSuccessfulConfiguration().getMuleContext().getExpressionManager().evaluate(ackExpression, event).getValue()).build()).build();
    }

    protected UntilSuccessfulConfiguration getUntilSuccessfulConfiguration() {
        return this.untilSuccessfulConfiguration;
    }

    @Override
    public Event route(Event event, FlowConstruct flow) throws MuleException {
        this.prepareAndValidateEvent(event);
        return this.doRoute(event, flow);
    }

    protected abstract Event doRoute(Event var1, FlowConstruct var2) throws MuleException;

    private void prepareAndValidateEvent(Event event) throws MessagingException {
        try {
            Message message = event.getMessage();
            if (message instanceof InternalMessage) {
                if (message.getPayload().getDataType().isStreamType()) {
                    event.getMessageAsBytes(this.muleContext);
                } else {
                    this.ensureSerializable(message);
                }
            } else {
                event.getMessageAsBytes(this.muleContext);
            }
        }
        catch (Exception e) {
            throw new MessagingException(I18nMessageFactory.createStaticMessage("Failed to prepare message for processing"), event, e, this.getUntilSuccessfulConfiguration().getRouter());
        }
    }

    protected void ensureSerializable(Message message) throws NotSerializableException {
        if (!(message.getPayload().getValue() instanceof Serializable)) {
            throw new NotSerializableException(message.getPayload().getDataType().getType().getCanonicalName());
        }
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

