/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.streaming.object;

import org.mule.runtime.api.util.Preconditions;

public final class InMemoryCursorIteratorConfig {
    private final int initialBufferSize;
    private final int bufferSizeIncrement;
    private final int maxBufferSize;

    public static InMemoryCursorIteratorConfig getDefault() {
        return new InMemoryCursorIteratorConfig(100, 100, 500);
    }

    public InMemoryCursorIteratorConfig(int initialBufferSize, int bufferSizeIncrement, int maxBufferSize) {
        Preconditions.checkArgument(initialBufferSize > 0, "initialBufferSize must be greater than zero bytes");
        Preconditions.checkArgument(bufferSizeIncrement >= 0, "bufferSizeIncrement cannot be a negative byte size");
        Preconditions.checkArgument(initialBufferSize <= maxBufferSize, "initialBufferSize cannot be bigger than the maxBufferSize");
        Preconditions.checkArgument(bufferSizeIncrement <= maxBufferSize, "bufferSizeIncrement cannot be bigger than the maxBufferSize");
        Preconditions.checkArgument(initialBufferSize + bufferSizeIncrement <= maxBufferSize, "initialBufferSize + bufferSizeIncrement cannot be bigger than the maxBufferSize, otherwise the buffer will never be able to expand");
        Preconditions.checkArgument(initialBufferSize > 0, "initialBufferSize must be greater than zero");
        Preconditions.checkArgument(bufferSizeIncrement >= 0, "bufferSizeIncrement cannot be negative");
        this.initialBufferSize = initialBufferSize;
        this.bufferSizeIncrement = bufferSizeIncrement;
        this.maxBufferSize = maxBufferSize;
    }

    public int getInitialBufferSize() {
        return this.initialBufferSize;
    }

    public int getBufferSizeIncrement() {
        return this.bufferSizeIncrement;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }
}

