/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.graph;

import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.transformer.graph.ConverterFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeConverterFilter
implements ConverterFilter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConverterFilter[] filters;

    public CompositeConverterFilter(ConverterFilter ... filters) {
        this.filters = filters;
    }

    @Override
    public List<Converter> filter(List<Converter> converters, DataType source, DataType result) {
        List<Converter> filteredTransformers = new LinkedList<Converter>(converters);
        for (ConverterFilter filter : this.filters) {
            if (filteredTransformers.size() <= 1) break;
            filteredTransformers = filter.filter(filteredTransformers, source, result);
        }
        return filteredTransformers;
    }
}

