/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.module.deployment.internal.ArtifactDeployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultArtifactDeployer<T extends DeployableArtifact>
implements ArtifactDeployer<T> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void deploy(T artifact) {
        try {
            artifact.install();
            artifact.init();
            artifact.start();
        }
        catch (Throwable t) {
            artifact.dispose();
            if (t instanceof DeploymentException) {
                throw (DeploymentException)t;
            }
            String msg = String.format("Failed to deploy artifact [%s]", artifact.getArtifactName());
            throw new DeploymentException(I18nMessageFactory.createStaticMessage(msg), t);
        }
    }

    @Override
    public void undeploy(T artifact) {
        try {
            this.tryToStopArtifact(artifact);
            this.tryToDisposeArtifact(artifact);
        }
        catch (Throwable t) {
            if (t instanceof DeploymentException) {
                throw (DeploymentException)t;
            }
            String msg = String.format("Failed to undeployArtifact artifact [%s]", artifact.getArtifactName());
            throw new DeploymentException(I18nMessageFactory.createStaticMessage(msg), t);
        }
    }

    private void tryToDisposeArtifact(T artifact) {
        try {
            artifact.dispose();
        }
        catch (Throwable t) {
            this.logger.error(String.format("Unable to cleanly dispose artifact '%s'. Restart Mule if you get errors redeploying this artifact", artifact.getArtifactName()), t);
        }
    }

    private void tryToStopArtifact(T artifact) {
        try {
            artifact.stop();
        }
        catch (Throwable t) {
            this.logger.error(String.format("Unable to cleanly stop artifact '%s'. Restart Mule if you get errors redeploying this artifact", artifact.getArtifactName()), t);
        }
    }
}

