/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;

public final class ParameterLayoutOrderDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    private static final int INITIAL_ORDER = 1;

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclaration declaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
        new IdempotentDeclarationWalker(){

            @Override
            public void onOperation(OperationDeclaration declaration) {
                ParameterLayoutOrderDeclarationEnricher.this.addMissingParameterOrders(declaration);
            }

            @Override
            public void onConfiguration(ConfigurationDeclaration declaration) {
                ParameterLayoutOrderDeclarationEnricher.this.addMissingParameterOrders(declaration);
            }

            @Override
            public void onSource(SourceDeclaration declaration) {
                ParameterLayoutOrderDeclarationEnricher.this.addMissingParameterOrders(declaration);
            }

            @Override
            protected void onConnectionProvider(ConnectionProviderDeclaration declaration) {
                ParameterLayoutOrderDeclarationEnricher.this.addMissingParameterOrders(declaration);
            }
        }.walk(declaration);
    }

    private void addMissingParameterOrders(ParameterizedDeclaration<?> declaration) {
        HashSet takenOrders = new HashSet();
        ArrayList nonOrderedParams = new ArrayList();
        declaration.getAllParameters().forEach(param -> {
            LayoutModel layoutModel = param.getLayoutModel();
            if (layoutModel.getOrder().isPresent()) {
                takenOrders.add(layoutModel.getOrder().get());
            } else {
                nonOrderedParams.add(param);
            }
        });
        AtomicInteger currentOrder = new AtomicInteger(1);
        nonOrderedParams.forEach(param -> param.setLayoutModel(LayoutModel.builderFrom(param.getLayoutModel()).order(this.getNextOrder(currentOrder, takenOrders)).build()));
    }

    private int getNextOrder(AtomicInteger init, Set<Integer> takenOrders) {
        while (takenOrders.contains(init.get())) {
            init.incrementAndGet();
        }
        return init.getAndIncrement();
    }
}

