/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.MessageExchangePattern;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.client.OperationOptions;
import org.mule.runtime.core.api.client.RequestCacheKey;
import org.mule.runtime.core.api.connector.ConnectorOperationProvider;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.processor.Processor;

public abstract class AbstractConnectorMessageProcessorProvider
implements ConnectorOperationProvider,
MuleContextAware,
Disposable {
    protected static final int CACHE_SIZE = 1000;
    protected static final int EXPIRATION_TIME_IN_MINUTES = 10;
    private final LoadingCache<RequestCacheKey, Processor> cachedMessageProcessors = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<RequestCacheKey, Processor>(){

        public Processor load(RequestCacheKey cacheKey) throws MuleException {
            return AbstractConnectorMessageProcessorProvider.this.buildMessageProcessor(cacheKey);
        }
    });
    protected MuleContext muleContext;

    protected abstract Processor buildMessageProcessor(RequestCacheKey var1) throws MuleException;

    @Override
    public Processor getMessageProcessor(String url, OperationOptions operationOptions, MessageExchangePattern exchangePattern) throws MuleException {
        try {
            return (Processor)this.cachedMessageProcessors.get(new RequestCacheKey<OperationOptions>(url, operationOptions, exchangePattern));
        }
        catch (ExecutionException e) {
            throw new DefaultMuleException(e);
        }
    }

    @Override
    public void dispose() {
        this.cachedMessageProcessors.invalidateAll();
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

