/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.component.simple;

import javax.inject.Inject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleEventContext;
import org.mule.runtime.core.api.component.simple.LogService;
import org.mule.runtime.core.api.lifecycle.Callable;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogComponent
implements Callable,
LogService {
    private static Logger logger = LoggerFactory.getLogger(LogComponent.class);
    @Inject
    private MuleContext muleContext;

    @Override
    public Object onCall(MuleEventContext context) throws Exception {
        String contents = context.getMessageAsString(this.muleContext);
        String msg = "Message received in service: " + context.getFlowConstruct().getName();
        msg = StringMessageUtils.getBoilerPlate(msg + ". Content is: '" + StringMessageUtils.truncate(contents, 100, true) + "'");
        this.log(msg);
        return context.getMessage();
    }

    @Override
    public void log(String message) {
        logger.info(message);
    }
}

