/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.object.iterator;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.core.internal.streaming.object.iterator.Producer;

public class CompositeProducer<T>
implements Producer<T> {
    private Integer totalAvailable = null;
    private List<Producer<T>> producers;
    private Iterator<Producer<T>> producersIterator;
    private Producer<T> currentProducer;

    public CompositeProducer(List<Producer<T>> producers) {
        if (CollectionUtils.isEmpty(producers)) {
            throw new IllegalArgumentException("Cannot make a composition of null or empty producers list");
        }
        this.producers = producers;
        this.producersIterator = producers.iterator();
        this.currentProducer = this.producersIterator.next();
    }

    public CompositeProducer(Producer<T> ... producers) {
        this(Arrays.asList(producers));
    }

    @Override
    public T produce() {
        if (this.currentProducer == null) {
            return null;
        }
        T next = this.currentProducer.produce();
        if (next == null) {
            this.currentProducer = this.producersIterator.hasNext() ? this.producersIterator.next() : null;
            return this.produce();
        }
        return next;
    }

    @Override
    public int getSize() {
        if (this.totalAvailable == null) {
            int total = 0;
            for (Producer<T> producer : this.producers) {
                int available = producer.getSize();
                if (available <= 0) continue;
                total += available;
            }
            this.totalAvailable = total;
        }
        return this.totalAvailable;
    }

    @Override
    public void close() throws IOException {
        for (Producer<T> producer : this.producers) {
            producer.close();
        }
    }
}

