/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.rx;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.mule.runtime.core.api.Event;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.SynchronousSink;

public final class Operators {
    private Operators() {
    }

    public static BiConsumer<Event, SynchronousSink<Event>> nullSafeMap(Function<Event, Event> mapper) {
        return (event, sink) -> {
            if (event != null) {
                Event result = (Event)mapper.apply((Event)event);
                if (result != null) {
                    sink.next((Object)result);
                } else {
                    event.getContext().success();
                }
            }
        };
    }

    public static BiConsumer<Event, SynchronousSink<Event>> echoOnNullMap(Function<Event, Event> mapper) {
        return (event, sink) -> {
            if (event != null) {
                Event result = (Event)mapper.apply((Event)event);
                if (result != null) {
                    sink.next((Object)result);
                } else {
                    sink.next(event);
                }
            }
        };
    }

    public static <T> Subscriber<T> requestUnbounded() {
        return RequstMaxSubscriber.INSTANCE;
    }

    static final class RequstMaxSubscriber<T>
    implements Subscriber<T> {
        static final RequstMaxSubscriber INSTANCE = new RequstMaxSubscriber();

        RequstMaxSubscriber() {
        }

        public void onSubscribe(Subscription s) {
            s.request(Long.MAX_VALUE);
        }

        public void onNext(Object o) {
        }

        public void onError(Throwable t) {
        }

        public void onComplete() {
        }
    }
}

