/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.catalog.model.resolver;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.json.JsonTypeLoader;
import org.mule.metadata.xml.SchemaCollector;
import org.mule.metadata.xml.XmlTypeLoader;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.internal.loader.catalog.model.resolver.TypeResolver;

public class SingleTypeResolver
implements TypeResolver {
    private static final String JSON_SUFFIX = "json";
    private static final String XSD_SUFFIX = "xsd";
    private String typeIdentifier;
    private final TypeLoader typeLoader;
    private final String element;

    public SingleTypeResolver(String typeIdentifier, URL schemaUrl, String element) {
        Preconditions.checkNotNull((Object)typeIdentifier);
        Preconditions.checkNotNull((Object)schemaUrl);
        this.element = element;
        this.typeLoader = this.getTypeLoader(schemaUrl);
        this.typeIdentifier = typeIdentifier;
    }

    private TypeLoader getTypeLoader(URL schemaUrl) {
        TypeLoader loader;
        if (schemaUrl.toString().endsWith(JSON_SUFFIX)) {
            loader = new JsonTypeLoader(this.getSchemaData(schemaUrl));
        } else if (schemaUrl.toString().endsWith(XSD_SUFFIX)) {
            SchemaCollector instance = SchemaCollector.getInstance();
            instance.addSchema(schemaUrl);
            loader = new XmlTypeLoader(instance);
        } else {
            throw new RuntimeException(String.format("The schema trying to be read [%s] is of a unknown type. Currently JSON or XML schemas are supported, and the must end with the suffix [%s] or [%s], respectively", schemaUrl.toString(), JSON_SUFFIX, XSD_SUFFIX));
        }
        return loader;
    }

    private String getSchemaData(URL schemaUrl) {
        try {
            return IOUtils.toString(schemaUrl.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("There was an issue while trying to read the schema from [%s]", schemaUrl.toString()), e);
        }
    }

    @Override
    public Optional<MetadataType> resolveType(String typeIdentifier) {
        return this.typeIdentifier.equals(typeIdentifier) ? this.getTypeWhileAddingIDToMakeItSerializable(typeIdentifier) : Optional.empty();
    }

    private Optional<MetadataType> getTypeWhileAddingIDToMakeItSerializable(String typeIdentifier) {
        Optional<MetadataType> load = this.loadMetadataTypeWithoutNPE();
        load.ifPresent(metadataType -> {
            if (metadataType instanceof ObjectType) {
                try {
                    Field annotationsField = BaseMetadataType.class.getDeclaredField("annotations");
                    annotationsField.setAccessible(true);
                    Map mapa = (Map)annotationsField.get(metadataType);
                    mapa.put(TypeIdAnnotation.class, new TypeIdAnnotation(typeIdentifier));
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                    throw new RuntimeException("this code must be removed", e);
                }
            }
        });
        return load;
    }

    private Optional<MetadataType> loadMetadataTypeWithoutNPE() {
        try {
            return this.typeLoader.load(this.element);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof NullPointerException) {
                throw new RuntimeException(String.format("the Smart Connector catalog's is missing the 'element' attribute due to MDM-42, which throws an NPE.\nTo workaround this issue, add an 'element' attribute with the proper QName for the type [%s] with the convention \"{<targetNamespace>}<rootElement>\"\ne.g: if targetNamespace=\"http://validationnamespace.raml.org\" and element name is \"User\", then the following value should be usedelement=\"{http://validationnamespace.raml.org}User\"", this.typeIdentifier), e.getCause());
            }
            throw e;
        }
    }
}

