/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.soap.api.client;

import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.extension.api.soap.security.SecurityStrategy;
import org.mule.runtime.soap.api.SoapVersion;
import org.mule.runtime.soap.api.client.SoapClientConfiguration;

public class SoapClientConfigurationBuilder {
    private String wsdlLocation;
    private String address;
    private String service;
    private String port;
    private SoapVersion version = SoapVersion.SOAP11;
    private boolean mtomEnabled;
    private List<SecurityStrategy> securities = new ArrayList<SecurityStrategy>();
    private MessageDispatcher dispatcher;
    private String encoding;

    SoapClientConfigurationBuilder() {
    }

    public SoapClientConfigurationBuilder withWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
        return this;
    }

    public SoapClientConfigurationBuilder withAddress(String address) {
        this.address = address;
        return this;
    }

    public SoapClientConfigurationBuilder withService(String service) {
        this.service = service;
        return this;
    }

    public SoapClientConfigurationBuilder withPort(String port) {
        this.port = port;
        return this;
    }

    public SoapClientConfigurationBuilder withEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public SoapClientConfigurationBuilder withVersion(SoapVersion version) {
        this.version = version;
        return this;
    }

    public SoapClientConfigurationBuilder enableMtom() {
        this.mtomEnabled = true;
        return this;
    }

    public SoapClientConfigurationBuilder withSecurity(SecurityStrategy security) {
        this.securities.add(security);
        return this;
    }

    public SoapClientConfigurationBuilder withDispatcher(MessageDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        return this;
    }

    public SoapClientConfiguration build() {
        Preconditions.checkNotNull(this.wsdlLocation, "WSDL location cannot be null");
        Preconditions.checkNotNull(this.service, "Service cannot be null");
        Preconditions.checkNotNull(this.port, "Port cannot be null");
        Preconditions.checkNotNull(this.dispatcher, "Message Dispatcher cannot be null");
        return new SoapClientConfiguration(this.wsdlLocation, this.address, this.service, this.port, this.version, this.mtomEnabled, this.securities, this.dispatcher, this.encoding);
    }
}

