/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.soap.api.message.dispatcher;

import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.extension.api.client.DefaultOperationParameters;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.soap.message.DispatchingRequest;
import org.mule.runtime.extension.api.soap.message.DispatchingResponse;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.soap.api.exception.DispatchingException;

public final class HttpConfigBasedMessageDispatcher
implements MessageDispatcher {
    private final String configName;
    private final ExtensionsClient client;

    public HttpConfigBasedMessageDispatcher(String configName, ExtensionsClient client) {
        this.configName = configName;
        this.client = client;
    }

    @Override
    public DispatchingResponse dispatch(DispatchingRequest context) {
        ImmutableMap headers = ImmutableMap.builder().putAll(context.getHeaders()).put((Object)"Content-Type", (Object)context.getContentType()).build();
        DefaultOperationParameters params = DefaultOperationParameters.builder().configName(this.configName).addParameter("method", HttpConstants.Method.POST.toString()).addParameter("url", context.getAddress()).addParameter("headers", headers).addParameter("parseResponse", false).addParameter("body", new TypedValue<InputStream>(context.getContent(), DataType.INPUT_STREAM)).build();
        try {
            Result<Object, Object> result = this.client.executeAsync("HTTP", "request", params).get();
            Map<String, String> httpHeaders = this.getHttpHeaders(result);
            InputStream content = this.getContent(result);
            return new DispatchingResponse(content, httpHeaders.get("Content-Type".toLowerCase()), httpHeaders);
        }
        catch (Exception e) {
            throw new DispatchingException("Could not dispatch soap message using the [" + this.configName + "] HTTP configuration", (Throwable)e);
        }
    }

    private Map<String, String> getHttpHeaders(Result<Object, Object> result) {
        try {
            Optional<Object> httpAttributes = result.getAttributes();
            if (!httpAttributes.isPresent()) {
                throw new IllegalStateException("No Http Attributes found on the response, cannot get response headers.");
            }
            Object headers = httpAttributes.get().getClass().getMethod("getHeaders", new Class[0]).invoke(httpAttributes.get(), new Object[0]);
            Map map = (Map)headers.getClass().getMethod("toListValuesMap", new Class[0]).invoke(headers, new Object[0]);
            return map.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((List)e.getValue()).stream().collect(Collectors.joining(" "))));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
            throw new IllegalStateException("Something went wrong when introspecting the http response attributes.", e2);
        }
    }

    private InputStream getContent(Result<Object, Object> result) {
        Object output = result.getOutput();
        if (output instanceof CursorStreamProvider) {
            return (InputStream)((CursorStreamProvider)output).openCursor();
        }
        if (output instanceof InputStream) {
            return (InputStream)output;
        }
        throw new IllegalStateException("Content was expected to be an stream but got a [" + output.getClass().getName() + "]");
    }

    @Override
    public void dispose() {
    }

    @Override
    public void initialise() throws InitialisationException {
    }
}

