/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.message.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;

class DefaultMuleEventMetadataType
extends BaseMetadataType
implements ObjectType,
MuleEventMetadataType {
    private static final String MESSAGE_FIELD_NAME = "message";
    private static final String VARIABLES_FIELD_NAME = "variables";
    private final ObjectFieldType messageMetadataType;
    private final ObjectFieldType variables;

    DefaultMuleEventMetadataType(MessageMetadataType messageMetadataType, ObjectType variables, Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations) {
        super(MetadataFormat.JAVA, annotations);
        ObjectFieldTypeBuilder messageTypeBuilder = new ObjectFieldTypeBuilder(MetadataFormat.JAVA);
        messageTypeBuilder.key(MESSAGE_FIELD_NAME).value(messageMetadataType);
        messageTypeBuilder.required(true);
        this.messageMetadataType = messageTypeBuilder.build();
        ObjectFieldTypeBuilder variablesTypeBuilder = new ObjectFieldTypeBuilder(MetadataFormat.JAVA);
        variablesTypeBuilder.required(true);
        variablesTypeBuilder.key(VARIABLES_FIELD_NAME).value(variables);
        this.variables = variablesTypeBuilder.build();
    }

    @Override
    public MessageMetadataType getMessageType() {
        return (MessageMetadataType)this.messageMetadataType.getValue();
    }

    @Override
    public ObjectType getVariables() {
        return (ObjectType)this.variables.getValue();
    }

    @Override
    public Optional<MetadataType> getVariableType(String varName) {
        return this.getVariables().getFieldByName(varName).map(ObjectFieldType::getValue);
    }

    @Override
    public Optional<MetadataType> getOpenRestriction() {
        return Optional.empty();
    }

    @Override
    public Collection<ObjectFieldType> getFields() {
        return Arrays.asList(this.messageMetadataType, this.variables);
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public Optional<ObjectFieldType> getFieldByName(String name) {
        switch (name) {
            case "message": {
                return Optional.ofNullable(this.messageMetadataType);
            }
            case "variables": {
                return Optional.ofNullable(this.variables);
            }
        }
        return Optional.empty();
    }

    @Override
    public void accept(MetadataTypeVisitor metadataTypeVisitor) {
        metadataTypeVisitor.visitObject(this);
    }
}

