/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.api.dsl.model.ApplicationModel;
import org.mule.runtime.config.internal.LazyComponentCreator;
import org.mule.runtime.config.internal.LazyConnectivityTestingService;
import org.mule.runtime.config.internal.LazyMetadataService;
import org.mule.runtime.config.internal.LazyValueProviderService;
import org.mule.runtime.config.internal.MuleArtifactContext;
import org.mule.runtime.config.internal.OptionalObjectsController;
import org.mule.runtime.config.internal.TrackingPostProcessor;
import org.mule.runtime.config.internal.dsl.model.ConfigurationDependencyResolver;
import org.mule.runtime.config.internal.dsl.model.MinimalApplicationModelGenerator;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigResource;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.connectivity.DefaultConnectivityTestingService;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.core.internal.value.MuleValueProviderService;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class LazyMuleArtifactContext
extends MuleArtifactContext
implements LazyComponentInitializer,
LazyComponentCreator {
    private TrackingPostProcessor trackingPostProcessor = new TrackingPostProcessor();

    public LazyMuleArtifactContext(MuleContext muleContext, ConfigResource[] artifactConfigResources, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController, Map<String, String> artifactProperties, ArtifactType artifactType, List<ClassLoader> pluginsClassLoaders, Optional<ConfigurationProperties> parentConfigurationProperties, boolean disableXmlValidations) throws BeansException {
        super(muleContext, artifactConfigResources, artifactDeclaration, optionalObjectsController, artifactProperties, artifactType, pluginsClassLoaders, parentConfigurationProperties, disableXmlValidations);
        this.applicationModel.executeOnEveryMuleComponentTree(componentModel -> componentModel.setEnabled(false));
        muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleConnectivityTestingService", new LazyConnectivityTestingService(this, () -> (ConnectivityTestingService)this.getRegistry().lookupByName("_muleNonLazyConnectivityTestingService").get()));
        muleContext.getCustomizationService().registerCustomServiceClass("_muleNonLazyConnectivityTestingService", DefaultConnectivityTestingService.class);
        muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleMetadataService", new LazyMetadataService(this, () -> (MetadataService)this.getRegistry().lookupByName("_muleNonLazyMetadataService").get()));
        muleContext.getCustomizationService().registerCustomServiceClass("_muleNonLazyMetadataService", MuleMetadataService.class);
        muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleValueProviderService", new LazyValueProviderService(this, this, () -> (ValueProviderService)this.getRegistry().lookupByName("_muleNonLazyValueProviderService").get(), muleContext::getConfigurationComponentLocator));
        muleContext.getCustomizationService().registerCustomServiceClass("_muleNonLazyValueProviderService", MuleValueProviderService.class);
        muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleLazyComponentInitializer", this);
    }

    @Override
    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        this.trackingPostProcessor = new TrackingPostProcessor();
        this.addBeanPostProcessors(beanFactory, this.trackingPostProcessor);
    }

    private void applyLifecycle(List<String> createdComponentModels) {
        this.muleContext.withLifecycleLock(() -> {
            Object object;
            if (this.muleContext.isInitialised()) {
                for (String createdComponentModelName : createdComponentModels) {
                    object = this.getRegistry().lookupByName(createdComponentModelName).get();
                    try {
                        LifecycleUtils.initialiseIfNeeded(object, true, (MuleContext)this.muleContext);
                    }
                    catch (InitialisationException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (this.muleContext.isStarted()) {
                for (String createdComponentModelName : createdComponentModels) {
                    object = this.getRegistry().lookupByName(createdComponentModelName).get();
                    try {
                        LifecycleUtils.startIfNeeded(object);
                    }
                    catch (MuleException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    @Override
    public void initializeComponent(Location location) {
        this.applyLifecycle(this.createComponents(Optional.empty(), Optional.of(location)));
    }

    @Override
    public void initializeComponents(LazyComponentInitializer.ComponentLocationFilter filter) {
        this.applyLifecycle(this.createComponents(Optional.of(filter), Optional.empty()));
    }

    @Override
    public void createComponent(Location location) {
        this.createComponents(Optional.empty(), Optional.of(location));
    }

    private List<String> createComponents(Optional<LazyComponentInitializer.ComponentLocationFilter> filterOptional, Optional<Location> locationOptional) {
        Preconditions.checkState(filterOptional.isPresent() != locationOptional.isPresent(), "filter or location has to be passed");
        ArrayList<String> alreadyCreatedApplicationComponents = new ArrayList<String>();
        alreadyCreatedApplicationComponents.addAll(this.trackingPostProcessor.getBeansTracked());
        Collections.reverse(alreadyCreatedApplicationComponents);
        this.trackingPostProcessor.startTracking();
        Reference createdComponents = new Reference();
        ClassUtils.withContextClassLoader(this.muleContext.getExecutionClassLoader(), () -> {
            this.unregisterBeans(alreadyCreatedApplicationComponents);
            ConfigurationDependencyResolver dependencyResolver = new ConfigurationDependencyResolver(this.applicationModel, this.componentBuildingDefinitionRegistry);
            MinimalApplicationModelGenerator minimalApplicationModelGenerator = new MinimalApplicationModelGenerator(dependencyResolver);
            Reference minimalApplicationModel = new Reference();
            filterOptional.ifPresent(filter -> minimalApplicationModel.set(minimalApplicationModelGenerator.getMinimalModel((LazyComponentInitializer.ComponentLocationFilter)filter)));
            locationOptional.ifPresent(location -> minimalApplicationModel.set(minimalApplicationModelGenerator.getMinimalModel((Location)location)));
            List<String> applicationComponents = this.createApplicationComponents((DefaultListableBeanFactory)this.getBeanFactory(), (ApplicationModel)minimalApplicationModel.get(), false);
            createdComponents.set(applicationComponents);
            applicationComponents.forEach(component -> this.getRegistry().lookupByName((String)component).get());
        });
        this.trackingPostProcessor.stopTracking();
        List createdComponentNames = (List)createdComponents.get();
        this.trackingPostProcessor.intersection(createdComponentNames);
        return createdComponentNames;
    }

    private void unregisterBeans(List<String> beanNames) {
        if (this.muleContext.isStarted()) {
            beanNames.forEach(beanName -> {
                block2: {
                    try {
                        LegacyRegistryUtils.unregisterObject(this.muleContext, beanName);
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)String.format("Exception unregistering an object during lazy initialization of component %s, exception message is %s", beanName, e.getMessage()));
                        if (!this.logger.isDebugEnabled()) break block2;
                        this.logger.debug((Object)e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        this.applicationModel.executeOnEveryMuleComponentTree(componentModel -> componentModel.setEnabled(false));
    }
}

