/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;

public class SpringConfigurationComponentLocator
implements ConfigurationComponentLocator {
    private Map<String, Component> componentsMap = new HashMap<String, Component>();
    private Set<ComponentLocation> componentLocations = new HashSet<ComponentLocation>();

    public void addComponent(Component component) {
        this.componentsMap.put(component.getLocation().getLocation(), component);
    }

    public void addComponentLocation(ComponentLocation location) {
        this.componentLocations.add(location);
    }

    @Override
    public Optional<Component> find(Location location) {
        return Optional.ofNullable(this.componentsMap.get(location.toString()));
    }

    @Override
    public List<Component> find(ComponentIdentifier componentIdentifier) {
        return this.componentsMap.values().stream().filter(component -> component.getLocation().getComponentIdentifier().getIdentifier().equals(componentIdentifier)).collect(Collectors.toList());
    }

    @Override
    public List<ComponentLocation> findAllLocations() {
        return Collections.unmodifiableList(new ArrayList<ComponentLocation>(this.componentLocations));
    }
}

