/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.ConnectionNotification;
import org.mule.runtime.api.notification.ConnectionNotificationListener;
import org.mule.runtime.api.notification.CustomNotification;
import org.mule.runtime.api.notification.CustomNotificationListener;
import org.mule.runtime.api.notification.ExceptionNotification;
import org.mule.runtime.api.notification.ExceptionNotificationListener;
import org.mule.runtime.api.notification.ManagementNotification;
import org.mule.runtime.api.notification.ManagementNotificationListener;
import org.mule.runtime.api.notification.SecurityNotification;
import org.mule.runtime.api.notification.SecurityNotificationListener;
import org.mule.runtime.api.notification.TransactionNotification;
import org.mule.runtime.api.notification.TransactionNotificationListener;
import org.mule.runtime.api.scheduler.SchedulerContainerPoolsConfig;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.config.internal.InjectParamsFromContextServiceProxy;
import org.mule.runtime.config.internal.NoOpLazyComponentInitializer;
import org.mule.runtime.config.internal.NotificationConfig;
import org.mule.runtime.config.internal.OptionalObjectsController;
import org.mule.runtime.config.internal.SchedulerBaseConfigFactory;
import org.mule.runtime.config.internal.ServerNotificationManagerConfigurator;
import org.mule.runtime.config.internal.SpringConfigurationComponentLocator;
import org.mule.runtime.config.internal.SpringRegistryBootstrap;
import org.mule.runtime.config.internal.dsl.model.config.DefaultComponentInitialStateManager;
import org.mule.runtime.config.internal.factories.ConstantFactoryBean;
import org.mule.runtime.config.internal.factories.ExtensionManagerFactoryBean;
import org.mule.runtime.config.internal.factories.TransactionManagerFactoryBean;
import org.mule.runtime.config.internal.processor.MuleObjectNameProcessor;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.context.notification.MuleContextNotification;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.DefaultStreamingManager;
import org.mule.runtime.core.internal.cluster.DefaultClusterService;
import org.mule.runtime.core.internal.config.CustomService;
import org.mule.runtime.core.internal.config.CustomServiceRegistry;
import org.mule.runtime.core.internal.connection.DefaultConnectionManager;
import org.mule.runtime.core.internal.connectivity.DefaultConnectivityTestingService;
import org.mule.runtime.core.internal.context.notification.DefaultNotificationDispatcher;
import org.mule.runtime.core.internal.context.notification.DefaultNotificationListenerRegistry;
import org.mule.runtime.core.internal.context.notification.MessageProcessingFlowTraceManager;
import org.mule.runtime.core.internal.el.DefaultExpressionManager;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.internal.exception.MessagingExceptionLocationProvider;
import org.mule.runtime.core.internal.execution.MuleMessageProcessingManager;
import org.mule.runtime.core.internal.lock.MuleLockFactory;
import org.mule.runtime.core.internal.lock.SingleServerLockProvider;
import org.mule.runtime.core.internal.management.stats.DefaultProcessingTimeWatcher;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.core.internal.policy.DefaultPolicyManager;
import org.mule.runtime.core.internal.policy.DefaultPolicyStateHandler;
import org.mule.runtime.core.internal.processor.interceptor.DefaultProcessorInterceptorManager;
import org.mule.runtime.core.internal.security.DefaultMuleSecurityManager;
import org.mule.runtime.core.internal.time.LocalTimeSupplier;
import org.mule.runtime.core.internal.transaction.TransactionFactoryLocator;
import org.mule.runtime.core.internal.transformer.DynamicDataTypeConversionResolver;
import org.mule.runtime.core.internal.util.DefaultStreamCloserService;
import org.mule.runtime.core.internal.util.queue.TransactionalQueueManager;
import org.mule.runtime.core.internal.util.store.DefaultObjectStoreFactoryBean;
import org.mule.runtime.core.internal.util.store.MuleObjectStoreManager;
import org.mule.runtime.core.internal.value.MuleValueProviderService;
import org.mule.runtime.core.privileged.transformer.ExtendedTransformationService;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

class SpringMuleContextServiceConfigurator {
    private final MuleContext muleContext;
    private final ArtifactType artifactType;
    private final OptionalObjectsController optionalObjectsController;
    private final CustomServiceRegistry customServiceRegistry;
    private final BeanDefinitionRegistry beanDefinitionRegistry;
    private static final ImmutableSet<String> APPLICATION_ONLY_SERVICES = ImmutableSet.builder().add((Object)"_muleSecurityManager").add((Object)"_muleMessageProcessingManager").add((Object)"_muleStreamCloserService").add((Object)"_converterResolver").add((Object)"_muleLockFactory").add((Object)"_muleLockProvider").add((Object)"_muleProcessingTimeWatcher").add((Object)"_muleExceptionLocationProvider").add((Object)"_muleMessageProcessingFlowTraceManager").build();
    private static final ImmutableMap<String, String> OBJECT_STORE_NAME_TO_LOCAL_OBJECT_STORE_NAME = ImmutableMap.builder().put((Object)"_defaultInMemoryObjectStore", (Object)"_localInMemoryObjectStore").put((Object)"_defaultPersistentObjectStore", (Object)"_localPersistentObjectStore").build();
    private final ImmutableMap<String, BeanDefinition> defaultContextServices = ImmutableMap.builder().put((Object)"_muleTransactionManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(TransactionManagerFactoryBean.class)).put((Object)"_defaultRetryPolicyTemplate", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(NoRetryPolicyTemplate.class)).put((Object)"_muleExpressionLanguage", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MVELExpressionLanguage.class)).put((Object)"_muleExpressionManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultExpressionManager.class)).put((Object)"_muleExtensionManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(ExtensionManagerFactoryBean.class)).put((Object)"_muleTimeSupplier", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(LocalTimeSupplier.class)).put((Object)"_muleConnectionManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultConnectionManager.class)).put((Object)"_muleMetadataService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleMetadataService.class)).put((Object)"_muleConfiguration", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultMuleConfiguration.class)).put((Object)"_muleValueProviderService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleValueProviderService.class)).put((Object)"_muleTransactionFactoryLocator", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(TransactionFactoryLocator.class)).put((Object)"_muleObjectNameProcessor", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleObjectNameProcessor.class)).put((Object)"_mulePolicyManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultPolicyManager.class)).put((Object)"_muleProcessorInterceptorManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultProcessorInterceptorManager.class)).put((Object)"_mulePolicyStateHandler", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultPolicyStateHandler.class)).put((Object)"_muleNotificationManager", (Object)SpringMuleContextServiceConfigurator.createNotificationManagerBeanDefinition()).put((Object)"_muleNotificationDispatcher", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultNotificationDispatcher.class)).put((Object)"_muleNotificationListenerRegistry", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultNotificationListenerRegistry.class)).put((Object)"_defaultInMemoryObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ConstantFactoryBean.class).addConstructorArgReference("_localInMemoryObjectStore").getBeanDefinition()).put((Object)"_localInMemoryObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultObjectStoreFactoryBean.class, "createDefaultInMemoryObjectStore")).put((Object)"_defaultPersistentObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ConstantFactoryBean.class).addConstructorArgReference("_localPersistentObjectStore").getBeanDefinition()).put((Object)"_localPersistentObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultObjectStoreFactoryBean.class, "createDefaultPersistentObjectStore")).put((Object)"_muleObjectStoreManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleObjectStoreManager.class)).put((Object)"_muleQueueManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(TransactionalQueueManager.class)).put((Object)"_muleSecurityManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultMuleSecurityManager.class)).put((Object)"_muleMessageProcessingManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleMessageProcessingManager.class)).put((Object)"_muleStreamCloserService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultStreamCloserService.class)).put((Object)"_converterResolver", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DynamicDataTypeConversionResolver.class)).put((Object)"_muleLockFactory", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleLockFactory.class)).put((Object)"_muleLockProvider", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(SingleServerLockProvider.class)).put((Object)"_muleProcessingTimeWatcher", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultProcessingTimeWatcher.class)).put((Object)"_muleExceptionLocationProvider", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MessagingExceptionLocationProvider.class)).put((Object)"_muleMessageProcessingFlowTraceManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MessageProcessingFlowTraceManager.class)).put((Object)"_muleConnectivityTestingService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultConnectivityTestingService.class)).put((Object)"_muleComponentInitialStateManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultComponentInitialStateManager.class)).put((Object)"_muleStreamingManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultStreamingManager.class)).put((Object)"_muleTransformationService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(ExtendedTransformationService.class)).put((Object)"_muleSchedulerPoolsConfig", (Object)SpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(SchedulerContainerPoolsConfig.getInstance())).put((Object)"_muleSchedulerBaseConfig", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(SchedulerBaseConfigFactory.class)).put((Object)"_muleClusterService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultClusterService.class)).put((Object)"_muleLazyComponentInitializer", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(NoOpLazyComponentInitializer.class)).build();
    private final SpringConfigurationComponentLocator componentLocator;
    private final ConfigurationProperties configurationProperties;
    private final Registry registry;

    public SpringMuleContextServiceConfigurator(MuleContext muleContext, ConfigurationProperties configurationProperties, ArtifactType artifactType, OptionalObjectsController optionalObjectsController, BeanDefinitionRegistry beanDefinitionRegistry, SpringConfigurationComponentLocator componentLocator, Registry registry) {
        this.muleContext = muleContext;
        this.configurationProperties = configurationProperties;
        this.customServiceRegistry = (CustomServiceRegistry)muleContext.getCustomizationService();
        this.artifactType = artifactType;
        this.optionalObjectsController = optionalObjectsController;
        this.beanDefinitionRegistry = beanDefinitionRegistry;
        this.componentLocator = componentLocator;
        this.registry = registry;
    }

    void createArtifactServices() {
        this.registerBeanDefinition("_muleDefaultObjectSerializer", SpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(this.muleContext.getObjectSerializer()));
        this.registerBeanDefinition("_muleConfigurationAttributesResolver", SpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(this.configurationProperties));
        this.registerBeanDefinition(ErrorTypeRepository.class.getName(), SpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(this.muleContext.getErrorTypeRepository()));
        this.registerBeanDefinition("_muleConfigurationComponentLocator", SpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(this.componentLocator));
        this.registerBeanDefinition("_muleNotificationHandler", SpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(this.muleContext.getNotificationManager()));
        this.registerBeanDefinition("_muleRegistry", SpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(this.registry));
        this.registerBeanDefinition("_muleStatistics", SpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(this.muleContext.getStatistics()));
        this.loadServiceConfigurators();
        this.defaultContextServices.entrySet().stream().filter(service -> !APPLICATION_ONLY_SERVICES.contains(service.getKey()) || this.artifactType.equals((Object)ArtifactType.APP)).forEach(service -> this.registerBeanDefinition((String)service.getKey(), (BeanDefinition)service.getValue()));
        this.createBootstrapBeanDefinitions();
        this.createLocalObjectStoreBeanDefinitions();
        this.createLocalLockFactoryBeanDefinitions();
        this.createQueueManagerBeanDefinitions();
        this.createCustomServices();
    }

    private void loadServiceConfigurators() {
        new SpiServiceRegistry().lookupProviders(ServiceConfigurator.class, Service.class.getClassLoader()).forEach(customizer -> customizer.configure(this.customServiceRegistry));
    }

    private void createCustomServices() {
        Map<String, CustomService> customServices = this.customServiceRegistry.getCustomServices();
        for (String serviceName : customServices.keySet()) {
            if (this.beanDefinitionRegistry.containsBeanDefinition(serviceName)) {
                throw new IllegalStateException("There is already a bean definition registered with key: " + serviceName);
            }
            CustomService customService = customServices.get(serviceName);
            BeanDefinition beanDefinition = this.getCustomServiceBeanDefinition(customService);
            this.registerBeanDefinition(serviceName, beanDefinition);
        }
    }

    private void registerBeanDefinition(String serviceId, BeanDefinition beanDefinition) {
        beanDefinition = this.customServiceRegistry.getOverriddenService(serviceId).map(this::getCustomServiceBeanDefinition).orElse(beanDefinition);
        this.beanDefinitionRegistry.registerBeanDefinition(serviceId, beanDefinition);
    }

    private BeanDefinition getCustomServiceBeanDefinition(CustomService customService) {
        AbstractBeanDefinition beanDefinition;
        Optional<Class> customServiceClass = customService.getServiceClass();
        Optional<Object> customServiceImpl = customService.getServiceImpl();
        if (customServiceClass.isPresent()) {
            beanDefinition = SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(customServiceClass.get()).getBeanDefinition();
        } else if (customServiceImpl.isPresent()) {
            beanDefinition = customServiceImpl.get() instanceof Service ? SpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(InjectParamsFromContextServiceProxy.createInjectProviderParamsServiceProxy((Service)customServiceImpl.get(), this.registry)) : SpringMuleContextServiceConfigurator.getConstantObjectBeanDefinition(customServiceImpl.get());
        } else {
            throw new IllegalStateException("A custom service must define a service class or instance");
        }
        return beanDefinition;
    }

    private void createQueueManagerBeanDefinitions() {
        AtomicBoolean customManagerDefined = new AtomicBoolean(false);
        this.customServiceRegistry.getOverriddenService("_muleQueueManager").ifPresent(customService -> {
            customManagerDefined.set(true);
            this.registerBeanDefinition("_muleQueueManager", this.getCustomServiceBeanDefinition((CustomService)customService));
        });
        if (customManagerDefined.get()) {
            this.registerBeanDefinition("_localQueueManager", SpringMuleContextServiceConfigurator.getBeanDefinition(TransactionalQueueManager.class));
        } else {
            this.beanDefinitionRegistry.registerAlias("_muleQueueManager", "_localQueueManager");
        }
    }

    private void createLocalLockFactoryBeanDefinitions() {
        AtomicBoolean customLockFactoryWasDefined = new AtomicBoolean(false);
        this.customServiceRegistry.getOverriddenService("_muleLockFactory").ifPresent(customService -> {
            customLockFactoryWasDefined.set(true);
            this.beanDefinitionRegistry.registerBeanDefinition("_muleLockFactory", this.getCustomServiceBeanDefinition((CustomService)customService));
        });
        if (customLockFactoryWasDefined.get()) {
            this.beanDefinitionRegistry.registerBeanDefinition("_muleLocalLockFactory", (BeanDefinition)this.defaultContextServices.get((Object)"_muleLockFactory"));
        } else {
            this.beanDefinitionRegistry.registerAlias("_muleLockFactory", "_muleLocalLockFactory");
        }
    }

    private void createLocalObjectStoreBeanDefinitions() {
        AtomicBoolean anyBaseStoreWasRedefined = new AtomicBoolean(false);
        OBJECT_STORE_NAME_TO_LOCAL_OBJECT_STORE_NAME.entrySet().forEach(objectStoreLocal -> this.customServiceRegistry.getOverriddenService((String)objectStoreLocal.getKey()).ifPresent(customService -> {
            anyBaseStoreWasRedefined.set(true);
            this.beanDefinitionRegistry.registerBeanDefinition((String)objectStoreLocal.getKey(), this.getCustomServiceBeanDefinition((CustomService)customService));
        }));
        if (anyBaseStoreWasRedefined.get()) {
            this.beanDefinitionRegistry.registerBeanDefinition("_muleLocalObjectStoreManager", (BeanDefinition)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(MuleObjectStoreManager.class).addPropertyValue("basePersistentStoreKey", (Object)"_localPersistentObjectStore").addPropertyValue("baseTransientStoreKey", (Object)"_localInMemoryObjectStore").getBeanDefinition());
        } else {
            this.beanDefinitionRegistry.registerAlias("_muleObjectStoreManager", "_muleLocalObjectStoreManager");
        }
    }

    private static BeanDefinition createNotificationManagerBeanDefinition() {
        return SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ServerNotificationManagerConfigurator.class).addPropertyValue("enabledNotifications", (Object)ImmutableList.builder().add(new NotificationConfig.EnabledNotificationConfig<MuleContextNotification, MuleContextNotificationListener>(MuleContextNotificationListener.class, MuleContextNotification.class)).add(new NotificationConfig.EnabledNotificationConfig<SecurityNotification, SecurityNotificationListener>(SecurityNotificationListener.class, SecurityNotification.class)).add(new NotificationConfig.EnabledNotificationConfig<ManagementNotification, ManagementNotificationListener>(ManagementNotificationListener.class, ManagementNotification.class)).add(new NotificationConfig.EnabledNotificationConfig<ConnectionNotification, ConnectionNotificationListener>(ConnectionNotificationListener.class, ConnectionNotification.class)).add(new NotificationConfig.EnabledNotificationConfig<CustomNotification, CustomNotificationListener>(CustomNotificationListener.class, CustomNotification.class)).add(new NotificationConfig.EnabledNotificationConfig<ExceptionNotification, ExceptionNotificationListener>(ExceptionNotificationListener.class, ExceptionNotification.class)).add(new NotificationConfig.EnabledNotificationConfig<TransactionNotification, TransactionNotificationListener>(TransactionNotificationListener.class, TransactionNotification.class)).build()).getBeanDefinition();
    }

    private void createBootstrapBeanDefinitions() {
        try {
            SpringRegistryBootstrap springRegistryBootstrap = new SpringRegistryBootstrap(this.artifactType, this.muleContext, this.optionalObjectsController, this::registerBeanDefinition);
            springRegistryBootstrap.initialise();
        }
        catch (InitialisationException e) {
            throw new RuntimeException(e);
        }
    }

    private static BeanDefinition getBeanDefinition(Class<?> beanType) {
        return SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(beanType).getBeanDefinition();
    }

    private static BeanDefinition getConstantObjectBeanDefinition(Object impl) {
        return SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ConstantFactoryBean.class).addConstructorArgValue(impl).getBeanDefinition();
    }

    private static BeanDefinitionBuilder getBeanDefinitionBuilder(Class<?> beanType) {
        return BeanDefinitionBuilder.genericBeanDefinition(beanType);
    }

    private static BeanDefinition getBeanDefinition(Class<?> beanType, String factoryMethodName) {
        return SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(beanType).setFactoryMethod(factoryMethodName).getBeanDefinition();
    }
}

