/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.spring;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ObjectFactory;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;

public class ObjectFactoryClassRepository {
    private Cache<ComponentBuildingDefinition, Class<ObjectFactory>> objectFactoryClassCache = CacheBuilder.newBuilder().removalListener(notification -> Enhancer.registerStaticCallbacks((Class)((Class)notification.getValue()), null)).build();

    public Class<ObjectFactory> getObjectFactoryClass(ComponentBuildingDefinition componentBuildingDefinition, Class objectFactoryType, Class createdObjectType, Supplier<Boolean> isLazyInitFunction, Consumer<Object> instancePostCreationFunction) {
        try {
            return (Class)this.objectFactoryClassCache.get((Object)componentBuildingDefinition, () -> this.getObjectFactoryDynamicClass(componentBuildingDefinition, objectFactoryType, createdObjectType, isLazyInitFunction, instancePostCreationFunction));
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private Class<ObjectFactory> getObjectFactoryDynamicClass(ComponentBuildingDefinition componentBuildingDefinition, Class objectFactoryType, Class createdObjectType, Supplier<Boolean> isLazyInitFunction, Consumer<Object> instancePostCreationFunction) {
        Enhancer enhancer = new Enhancer();
        enhancer.setInterfaces(new Class[]{SmartFactoryBean.class});
        enhancer.setSuperclass(objectFactoryType);
        enhancer.setCallbackType(MethodInterceptor.class);
        if (SmartFactoryBean.class.getClassLoader() != objectFactoryType.getClassLoader()) {
            enhancer.setClassLoader((ClassLoader)new CompositeClassLoader(ObjectFactoryClassRepository.class.getClassLoader(), objectFactoryType.getClassLoader()));
        }
        enhancer.setUseCache(false);
        Class factoryBeanClass = enhancer.createClass();
        Enhancer.registerStaticCallbacks((Class)factoryBeanClass, (Callback[])new Callback[]{(obj, method, args, proxy) -> {
            if (method.getName().equals("isSingleton")) {
                return !componentBuildingDefinition.isPrototype();
            }
            if (method.getName().equals("getObjectType")) {
                return createdObjectType;
            }
            if (method.getName().equals("getObject")) {
                Object createdInstance = proxy.invokeSuper(obj, args);
                instancePostCreationFunction.accept(createdInstance);
                return createdInstance;
            }
            if (method.getName().equals("isPrototype")) {
                return componentBuildingDefinition.isPrototype();
            }
            if (method.getName().equals("isEagerInit")) {
                return (Boolean)isLazyInitFunction.get() == false;
            }
            return proxy.invokeSuper(obj, args);
        }});
        return factoryBeanClass;
    }

    public void destroy() {
        this.objectFactoryClassCache.invalidateAll();
    }
}

