/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.transformer;

import java.nio.charset.Charset;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.MessageTransformer;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.privileged.client.MuleClientFlowConstruct;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public abstract class AbstractMessageTransformer
extends AbstractTransformer
implements MessageTransformer {
    @Override
    public boolean isSourceDataTypeSupported(DataType dataType, boolean exactMatch) {
        return super.isSourceDataTypeSupported(dataType, exactMatch) || Message.class.isAssignableFrom(dataType.getType());
    }

    @Override
    public final Object doTransform(Object src, Charset enc) throws TransformerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Object transform(Object src, Charset enc) throws TransformerException {
        try {
            return this.transform(src, enc, null);
        }
        catch (MessageTransformerException e) {
            TransformerException te;
            Throwable cause = e.getCause();
            if (cause instanceof TransformerException && (te = (TransformerException)cause).getTransformer() == this) {
                throw te;
            }
            throw new TransformerException(e.getI18nMessage(), this, (Throwable)e);
        }
    }

    @Override
    public Object transform(Object src, CoreEvent event) throws MessageTransformerException {
        return this.transform(src, this.resolveEncoding(src), event);
    }

    @Override
    public final Object transform(Object src, Charset enc, CoreEvent event) throws MessageTransformerException {
        Message message;
        DataType sourceType = DataType.fromType(src.getClass());
        if (!this.isSourceDataTypeSupported(sourceType)) {
            if (this.isIgnoreBadInput()) {
                this.logger.debug("Source type is incompatible with this transformer and property 'ignoreBadInput' is set to true, so the transformer chain will continue.");
                return src;
            }
            I18nMessage msg = CoreMessages.transformOnObjectUnsupportedTypeOfEndpoint(this.getName(), src.getClass());
            throw new MessageTransformerException(msg, this, event.getMessage());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Applying transformer %s (%s)", this.getName(), this.getClass().getName()));
            this.logger.debug(String.format("Object before transform: %s", StringMessageUtils.toString(src)));
        }
        if (src instanceof Message) {
            message = (Message)src;
        } else if (src instanceof CoreEvent) {
            event = (CoreEvent)src;
            message = event.getMessage();
        } else if (this.muleContext.getConfiguration().isAutoWrapMessageAwareTransform()) {
            message = Message.of(src);
        } else {
            if (event == null) {
                throw new MessageTransformerException(CoreMessages.noCurrentEventForTransformer(), this, null);
            }
            message = event.getMessage();
        }
        if (event == null) {
            MuleClientFlowConstruct flowConstruct = new MuleClientFlowConstruct(this.muleContext);
            ComponentLocation location = this.getLocation() != null ? this.getLocation() : DefaultComponentLocation.fromSingleComponent("AbstractMessageTransformer");
            event = InternalEvent.builder(EventContextFactory.create(flowConstruct, location)).message(message).build();
        }
        Object result = this.transformMessage(event, enc);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Object after transform: %s", StringMessageUtils.toString(result)));
        }
        result = this.checkReturnClass(result, event);
        return result;
    }

    protected Object checkReturnClass(Object object, CoreEvent event) throws MessageTransformerException {
        if (object == null && this.isAllowNullReturn()) {
            return object;
        }
        if (this.getReturnDataType() != null) {
            DataType dt = DataType.fromObject(object);
            if (!this.getReturnDataType().isCompatibleWith(dt)) {
                throw new MessageTransformerException(CoreMessages.transformUnexpectedType(dt, this.getReturnDataType()), this, event.getMessage());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("The transformed object is of expected type. Type is: " + ClassUtils.getSimpleName(object.getClass()));
        }
        return object;
    }

    public abstract Object transformMessage(CoreEvent var1, Charset var2) throws MessageTransformerException;
}

