/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.func.CheckedFunction;

public final class StreamingUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoreEvent withCursoredEvent(CoreEvent event, final CheckedFunction<CoreEvent, CoreEvent> f) throws MuleException {
        if (event.getMessage().getPayload() == null) {
            return event;
        }
        final Reference<Throwable> exception = new Reference<Throwable>();
        CheckedFunction<CoreEvent, CoreEvent> function = new CheckedFunction<CoreEvent, CoreEvent>(){

            @Override
            public CoreEvent applyChecked(CoreEvent event) throws Throwable {
                return (CoreEvent)f.apply(event);
            }

            @Override
            public CoreEvent handleException(Throwable throwable) {
                exception.set(Exceptions.unwrap(throwable));
                return null;
            }
        };
        Object payload = event.getMessage().getPayload().getValue();
        CursorProvider cursorProvider = null;
        Cursor cursor = null;
        try {
            CoreEvent value;
            if (payload instanceof CursorProvider) {
                cursorProvider = (CursorProvider)payload;
                cursor = (Cursor)cursorProvider.openCursor();
                event = StreamingUtils.replacePayload(event, cursor);
            }
            if ((value = (CoreEvent)function.apply(event)) == null) {
                StreamingUtils.handlePossibleException(exception);
            } else if (value.getMessage().getPayload().getValue() == cursor) {
                value = StreamingUtils.replacePayload(value, cursorProvider);
            }
            CoreEvent coreEvent = value;
            return coreEvent;
        }
        finally {
            if (cursor != null) {
                StreamingUtils.closeQuietly(cursor);
            }
        }
    }

    public static Object streamingContent(Object value, CursorProviderFactory cursorProviderFactory, CoreEvent event) {
        if (cursorProviderFactory != null && cursorProviderFactory.accepts(value)) {
            return cursorProviderFactory.of(event, value);
        }
        return value;
    }

    public static boolean closeQuietly(Cursor cursor) {
        if (cursor == null) {
            return false;
        }
        try {
            cursor.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static CoreEvent replacePayload(CoreEvent event, Object newPayload) {
        return CoreEvent.builder(event).message(Message.builder(event.getMessage()).value(newPayload).build()).build();
    }

    private static void handlePossibleException(Reference<Throwable> exception) throws MuleException {
        Throwable t = exception.get();
        if (t != null) {
            throw Exceptions.rxExceptionToMuleException(t);
        }
    }

    private StreamingUtils() {
    }

    public static TypedValue updateTypedValueForStreaming(TypedValue value, CoreEvent event, StreamingManager streamingManager) {
        if (event == null) {
            return value;
        }
        Object payload = value.getValue();
        if (payload instanceof CursorProvider) {
            CursorProvider cursorProvider = streamingManager.manage((CursorProvider)payload, event);
            DataType dataType = DataType.builder(value.getDataType()).type(cursorProvider.getClass()).build();
            return new TypedValue<CursorProvider>(cursorProvider, dataType, value.getLength());
        }
        return value;
    }

    public static Function<CoreEvent, CoreEvent> updateEventForStreaming(StreamingManager streamingManager) {
        return event -> {
            TypedValue payload = event.getMessage().getPayload();
            if (payload.getValue() instanceof CursorProvider) {
                Message message = Message.builder(event.getMessage()).payload(StreamingUtils.updateTypedValueForStreaming(payload, event, streamingManager)).build();
                return CoreEvent.builder(event).message(message).build();
            }
            return event;
        };
    }
}

