/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context;

import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.bootstrap.BootstrapServiceDiscoverer;
import org.mule.runtime.core.api.config.bootstrap.PropertiesBootstrapServiceDiscoverer;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.context.MuleContextBuilder;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.exception.SystemExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.exception.DefaultSystemExceptionStrategy;
import org.mule.runtime.core.internal.exception.ErrorTypeLocatorFactory;
import org.mule.runtime.core.internal.exception.ErrorTypeRepositoryFactory;
import org.mule.runtime.core.internal.lifecycle.MuleContextLifecycleManager;
import org.mule.runtime.core.internal.registry.DefaultRegistryBroker;
import org.mule.runtime.core.internal.registry.MuleRegistryHelper;
import org.mule.runtime.core.internal.registry.RegistryDelegatingInjector;
import org.mule.runtime.core.internal.serialization.JavaObjectSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMuleContextBuilder
implements MuleContextBuilder {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultMuleContextBuilder.class);
    private final ArtifactType artifactType;
    protected MuleConfiguration config;
    private MuleContextLifecycleManager lifecycleManager;
    protected ServerNotificationManager notificationManager;
    protected ClassLoader executionClassLoader;
    protected ObjectSerializer objectSerializer;
    private ErrorTypeRepository errorTypeRepository;

    public DefaultMuleContextBuilder(ArtifactType artifactType) {
        this.artifactType = artifactType;
    }

    @Override
    public MuleContext buildMuleContext() {
        logger.debug("Building new DefaultMuleContext instance with MuleContextBuilder: " + this);
        DefaultMuleContext muleContext = this.createDefaultMuleContext();
        muleContext.setMuleConfiguration(this.injectMuleContextIfRequired(this.getMuleConfiguration(), muleContext));
        muleContext.setNotificationManager(this.injectMuleContextIfRequired(this.getNotificationManager(), muleContext));
        muleContext.setLifecycleManager(this.injectMuleContextIfRequired(this.getLifecycleManager(), muleContext));
        muleContext.setArtifactType(this.artifactType);
        DefaultRegistryBroker registryBroker = new DefaultRegistryBroker(muleContext);
        muleContext.setRegistryBroker(registryBroker);
        MuleRegistryHelper muleRegistry = new MuleRegistryHelper(registryBroker, muleContext);
        muleContext.setMuleRegistry(muleRegistry);
        muleContext.setInjector(new RegistryDelegatingInjector(muleRegistry));
        muleContext.setExceptionListener(this.createExceptionListener(muleContext));
        muleContext.setExecutionClassLoader(this.getExecutionClassLoader());
        muleContext.setBootstrapServiceDiscoverer(this.injectMuleContextIfRequired(this.createBootstrapDiscoverer(), muleContext));
        this.getObjectSerializer(muleContext);
        if (this.errorTypeRepository == null) {
            this.errorTypeRepository = ErrorTypeRepositoryFactory.createDefaultErrorTypeRepository();
        }
        muleContext.setErrorTypeRepository(this.errorTypeRepository);
        muleContext.setErrorTypeLocator(ErrorTypeLocatorFactory.createDefaultErrorTypeLocator(this.errorTypeRepository));
        return muleContext;
    }

    private void getObjectSerializer(DefaultMuleContext muleContext) {
        if (this.objectSerializer == null) {
            this.objectSerializer = new JavaObjectSerializer();
        }
        if (this.objectSerializer instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.objectSerializer)).setMuleContext(muleContext);
        }
        muleContext.setObjectSerializer(this.objectSerializer);
    }

    private SystemExceptionHandler createExceptionListener(DefaultMuleContext muleContext) {
        SystemExceptionHandler systemExceptionHandler = (SystemExceptionHandler)muleContext.getRegistry().get("_exceptionListenerFactory");
        if (systemExceptionHandler == null) {
            systemExceptionHandler = new DefaultSystemExceptionStrategy();
        }
        return systemExceptionHandler;
    }

    protected DefaultMuleContext createDefaultMuleContext() {
        return new DefaultMuleContext();
    }

    @Override
    public void setMuleConfiguration(MuleConfiguration config) {
        this.config = config;
    }

    @Override
    public void setNotificationManager(ServerNotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    protected MuleConfiguration getMuleConfiguration() {
        if (this.config != null) {
            return this.config;
        }
        return this.createMuleConfiguration();
    }

    @Override
    public void setExecutionClassLoader(ClassLoader executionClassLoader) {
        this.executionClassLoader = executionClassLoader;
    }

    @Override
    public void setObjectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
    }

    protected ClassLoader getExecutionClassLoader() {
        if (this.executionClassLoader != null) {
            return this.executionClassLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public void setErrorTypeRepository(ErrorTypeRepository errorTypeRepository) {
        this.errorTypeRepository = errorTypeRepository;
    }

    private <T> T injectMuleContextIfRequired(T object, MuleContext muleContext) {
        if (object instanceof MuleContextAware) {
            ((MuleContextAware)object).setMuleContext(muleContext);
        }
        return object;
    }

    protected LifecycleManager getLifecycleManager() {
        if (this.lifecycleManager != null) {
            return this.lifecycleManager;
        }
        return this.createLifecycleManager();
    }

    @Override
    public void setLifecycleManager(LifecycleManager manager) {
        if (!(manager instanceof MuleContextLifecycleManager)) {
            I18nMessage msg = I18nMessageFactory.createStaticMessage("lifecycle manager for MuleContext must be a MuleContextLifecycleManager");
            throw new MuleRuntimeException(msg);
        }
        this.lifecycleManager = (MuleContextLifecycleManager)manager;
    }

    protected ServerNotificationManager getNotificationManager() {
        if (this.notificationManager != null) {
            return this.notificationManager;
        }
        return this.createNotificationManager();
    }

    private BootstrapServiceDiscoverer createBootstrapDiscoverer() {
        return new PropertiesBootstrapServiceDiscoverer(DefaultMuleContextBuilder.class.getClassLoader());
    }

    protected DefaultMuleConfiguration createMuleConfiguration() {
        return new DefaultMuleConfiguration();
    }

    private MuleContextLifecycleManager createLifecycleManager() {
        return new MuleContextLifecycleManager();
    }

    protected ServerNotificationManager createNotificationManager() {
        return ServerNotificationManager.createDefaultNotificationManager();
    }

    public String toString() {
        return ClassUtils.getClassName(this.getClass()) + "{muleConfiguration=" + this.config + ", lifecycleManager=" + this.lifecycleManager + ", notificationManager=" + this.notificationManager + "}";
    }
}

