/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.notification;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.context.notification.FlowStackElement;

public class DefaultFlowCallStack
implements FlowCallStack {
    private static final long serialVersionUID = -8683711977929802819L;
    private Stack<FlowStackElement> innerStack = new Stack();

    public void push(FlowStackElement flowStackElement) {
        this.innerStack.push(flowStackElement);
    }

    public void setCurrentProcessorPath(String processorPath) {
        FlowStackElement topElement = this.innerStack.pop();
        this.innerStack.push(new FlowStackElement(topElement.getFlowName(), processorPath));
    }

    public FlowStackElement pop() {
        return this.innerStack.pop();
    }

    @Override
    public List<FlowStackElement> getElements() {
        ArrayList<FlowStackElement> elementsCloned = new ArrayList<FlowStackElement>();
        for (int i = this.innerStack.size() - 1; i >= 0; --i) {
            elementsCloned.add((FlowStackElement)this.innerStack.get(i));
        }
        return elementsCloned;
    }

    @Override
    public DefaultFlowCallStack clone() {
        DefaultFlowCallStack cloned = new DefaultFlowCallStack();
        for (int i = 0; i < this.innerStack.size(); ++i) {
            cloned.innerStack.push((FlowStackElement)this.innerStack.get(i));
        }
        return cloned;
    }

    public String toString() {
        StringBuilder stackString = new StringBuilder();
        for (int i = this.innerStack.size() - 1; i >= 0; --i) {
            stackString.append("at ").append(((FlowStackElement)this.innerStack.get(i)).toString());
            if (i == 0) continue;
            stackString.append(System.lineSeparator());
        }
        return stackString.toString();
    }
}

