/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.mvel.function;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.component.execution.ExecutableComponent;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;

public class LookupFunction
implements ExpressionFunction {
    private static final DataType TYPED_VALUE = DataType.fromType(TypedValue.class);
    private final ConfigurationComponentLocator componentLocator;

    public LookupFunction(ConfigurationComponentLocator componentLocator) {
        this.componentLocator = componentLocator;
    }

    @Override
    public Object call(Object[] parameters, BindingContext context) {
        String flowName = (String)parameters[0];
        Object payload = parameters[1];
        Location componentLocation = Location.builder().globalName(flowName).build();
        Component component = this.componentLocator.find(componentLocation).orElseThrow(() -> new IllegalArgumentException(String.format("There is no component named '%s'.", flowName)));
        if (component instanceof Flow) {
            try {
                Message incomingMessage = this.lookupValue(context, "message", Message.builder().nullValue().build());
                Map incomingVariables = this.lookupValue(context, "vars", Collections.EMPTY_MAP);
                Error incomingError = this.lookupValue(context, "error", null);
                Message message = Message.builder(incomingMessage).value(payload).build();
                CoreEvent event = CoreEvent.builder(PrivilegedEvent.getCurrentEvent().getContext()).variables(incomingVariables).error(incomingError).message(message).build();
                return ((ExecutableComponent)component).execute(event).get().getMessage().getPayload();
            }
            catch (ExecutionException e) {
                ComponentExecutionException componentExecutionException = (ComponentExecutionException)e.getCause();
                Error error = componentExecutionException.getEvent().getError().get();
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Flow '%s' has failed with error '%s' (%s)", flowName, error.getErrorType(), error.getDescription())), error.getCause());
            }
            catch (InterruptedException e) {
                throw new MuleRuntimeException(e);
            }
        }
        throw new IllegalArgumentException(String.format("Component '%s' is not a flow.", flowName));
    }

    @Override
    public Optional<DataType> returnType() {
        return Optional.of(TYPED_VALUE);
    }

    @Override
    public List<FunctionParameter> parameters() {
        return Arrays.asList(new FunctionParameter("flowName", DataType.STRING), new FunctionParameter("payload", DataType.OBJECT));
    }

    private <T> T lookupValue(BindingContext context, String binding, T fallback) {
        return (T)context.lookup(binding).map(typedValue -> typedValue.getValue()).orElse(fallback);
    }
}

