/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.util.rx.Operators;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

abstract class AbstractEventContext
implements BaseEventContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventContext.class);
    protected static final FlowExceptionHandler NULL_EXCEPTION_HANDLER = NullExceptionHandler.getInstance();
    private transient MonoProcessor<CoreEvent> beforeResponseProcessor;
    private transient MonoProcessor<CoreEvent> responseProcessor;
    private transient MonoProcessor<Void> completionProcessor;
    private transient Disposable completionSubscriberDisposable;
    private final transient List<BaseEventContext> childContexts = new LinkedList<BaseEventContext>();
    private transient Mono<Void> completionCallback = Mono.empty();
    private transient FlowExceptionHandler exceptionHandler;

    public AbstractEventContext() {
        this(NULL_EXCEPTION_HANDLER, (Publisher<Void>)Mono.empty());
    }

    public AbstractEventContext(FlowExceptionHandler exceptionHandler) {
        this(exceptionHandler, (Publisher<Void>)Mono.empty());
    }

    public AbstractEventContext(FlowExceptionHandler exceptionHandler, Publisher<Void> completionCallback) {
        this.completionCallback = Mono.from(completionCallback);
        this.exceptionHandler = exceptionHandler;
        this.initCompletionProcessor();
    }

    private void initCompletionProcessor() {
        this.beforeResponseProcessor = MonoProcessor.create();
        this.responseProcessor = MonoProcessor.create();
        this.responseProcessor.doOnEach(s -> s.accept(this.beforeResponseProcessor)).subscribe(Operators.requestUnbounded());
        this.completionProcessor = MonoProcessor.create();
        this.completionProcessor.doFinally(e -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " execution completed.");
            }
        }).subscribe();
        this.completionSubscriberDisposable = Mono.whenDelayError((Publisher[])new Publisher[]{this.completionCallback, this.responseProcessor.materialize().then()}).doOnEach(s -> s.accept(this.completionProcessor)).subscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChildContext(BaseEventContext childContext) {
        AbstractEventContext abstractEventContext = this;
        synchronized (abstractEventContext) {
            this.childContexts.add(childContext);
            this.updateCompletionPublisher();
        }
    }

    private void updateCompletionPublisher() {
        this.completionSubscriberDisposable.dispose();
        this.completionSubscriberDisposable = this.responseProcessor.onErrorResume(throwable -> Mono.empty()).and(this.completionCallback).and(this.getChildCompletionPublisher()).materialize().then().doOnEach(s -> s.accept(this.completionProcessor)).subscribe();
    }

    private Mono<Void> getChildCompletionPublisher() {
        return Mono.when((Iterable)this.childContexts.stream().map(eventContext -> Mono.from(eventContext.getCompletionPublisher())).collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void success() {
        AbstractEventContext abstractEventContext = this;
        synchronized (abstractEventContext) {
            if (this.responseProcessor.isTerminated()) {
                LOGGER.debug(this + " empty response was already completed, ignoring.");
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " response completed with no result.");
            }
            this.responseProcessor.onComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void success(CoreEvent event) {
        AbstractEventContext abstractEventContext = this;
        synchronized (abstractEventContext) {
            if (this.responseProcessor.isTerminated()) {
                LOGGER.debug(this + " response was already completed, ignoring.");
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " response completed with result.");
            }
            this.responseProcessor.onNext((Object)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Publisher<Void> error(Throwable throwable) {
        AbstractEventContext abstractEventContext = this;
        synchronized (abstractEventContext) {
            if (this.responseProcessor.isTerminated()) {
                LOGGER.debug(this + " error response was already completed, ignoring.");
                return Mono.empty();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " response completed with error.");
            }
            if (throwable instanceof MessagingException) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(this + " handling messaging exception.");
                }
                return Mono.just((Object)((MessagingException)throwable)).flatMapMany((Function)this.exceptionHandler).doOnNext(handled -> this.success((CoreEvent)handled)).doOnError(rethrown -> this.responseProcessor.onError(rethrown)).materialize().then().toProcessor();
            }
            this.responseProcessor.onError(throwable);
            return Mono.empty();
        }
    }

    @Override
    public Publisher<CoreEvent> getBeforeResponsePublisher() {
        return this.beforeResponseProcessor;
    }

    @Override
    public Publisher<CoreEvent> getResponsePublisher() {
        return this.responseProcessor;
    }

    @Override
    public Publisher<Void> getCompletionPublisher() {
        return this.completionProcessor;
    }

    protected FlowExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }
}

