/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.notification.ConnectorMessageNotification;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.NotificationHelper;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.execution.MessageProcessPhase;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.execution.MessageProcessTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NotificationFiringProcessingPhase<Template extends MessageProcessTemplate>
implements MessageProcessPhase<Template>,
Comparable<MessageProcessPhase> {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConcurrentHashMap<ServerNotificationManager, NotificationHelper> notificationHelpers = new ConcurrentHashMap();
    protected MuleContext muleContext;

    protected void fireNotification(Component source, CoreEvent event, FlowConstruct flow, int action) {
        try {
            if (event == null && (event = PrivilegedEvent.getCurrentEvent()) == null) {
                return;
            }
            this.getNotificationHelper(this.muleContext.getNotificationManager()).fireNotification(source, event, flow, action);
        }
        catch (Exception e) {
            this.logger.warn("Could not fire notification. Action: " + action, (Throwable)e);
        }
    }

    protected NotificationHelper getNotificationHelper(ServerNotificationManager serverNotificationManager) {
        NotificationHelper notificationHelper = this.notificationHelpers.get(serverNotificationManager);
        if (notificationHelper == null) {
            notificationHelper = new NotificationHelper(serverNotificationManager, ConnectorMessageNotification.class, false);
            this.notificationHelpers.putIfAbsent(serverNotificationManager, notificationHelper);
        }
        return notificationHelper;
    }

    @Inject
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

