/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.IteratorUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.PartitionableObjectStore;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.privileged.event.DefaultMuleSession;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.store.DeserializationPostInitialisable;

public class EventGroup
implements Comparable<EventGroup>,
Serializable,
DeserializationPostInitialisable {
    private static final long serialVersionUID = 953739659615692697L;
    public static final PrivilegedEvent[] EMPTY_EVENTS_ARRAY = new PrivilegedEvent[0];
    public static final String MULE_ARRIVAL_ORDER_PROPERTY = "MULE_ARRIVAL_ORDER";
    private final Object groupId;
    private transient PartitionableObjectStore<CoreEvent> eventsObjectStore;
    private final String storePrefix;
    private final String eventsPartitionKey;
    private final long created = System.currentTimeMillis();
    private final Integer expectedSize;
    private transient MuleContext muleContext;
    private int arrivalOrderCounter = 0;
    public static final String DEFAULT_STORE_PREFIX = "DEFAULT_STORE";

    public EventGroup(Object groupId, MuleContext muleContext) {
        this(groupId, muleContext, Optional.empty(), DEFAULT_STORE_PREFIX);
    }

    public EventGroup(Object groupId, MuleContext muleContext, Optional<Integer> expectedSize, String storePrefix) {
        this.muleContext = muleContext;
        this.storePrefix = storePrefix;
        this.eventsPartitionKey = storePrefix + ".eventGroups." + groupId;
        this.expectedSize = expectedSize.orElse(null);
        this.groupId = groupId;
    }

    @Override
    public int compareTo(EventGroup other) {
        Object otherId = other.getGroupId();
        if (this.groupId instanceof Comparable && otherId instanceof Comparable) {
            return ((Comparable)this.groupId).compareTo(otherId);
        }
        long diff = this.created - other.getCreated();
        return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EventGroup)) {
            return false;
        }
        EventGroup other = (EventGroup)obj;
        if (this.groupId == null) {
            return other.groupId == null;
        }
        return this.groupId.equals(other.groupId);
    }

    public int hashCode() {
        return this.groupId.hashCode();
    }

    public Object getGroupId() {
        return this.groupId;
    }

    public Iterator<CoreEvent> iterator() throws ObjectStoreException {
        return this.iterator(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CoreEvent> iterator(boolean sortByArrival) throws ObjectStoreException {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            if (this.eventsObjectStore.allKeys(this.eventsPartitionKey).isEmpty()) {
                return IteratorUtils.emptyIterator();
            }
            return IteratorUtils.arrayIterator((Object[])this.toArray(sortByArrival));
        }
    }

    public PrivilegedEvent[] toArray() throws ObjectStoreException {
        return this.toArray(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivilegedEvent[] toArray(boolean sortByArrival) throws ObjectStoreException {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            if (this.eventsObjectStore.allKeys(this.eventsPartitionKey).isEmpty()) {
                return EMPTY_EVENTS_ARRAY;
            }
            List<String> keys = this.eventsObjectStore.allKeys(this.eventsPartitionKey);
            PrivilegedEvent[] eventArray = new PrivilegedEvent[keys.size()];
            for (int i = 0; i < keys.size(); ++i) {
                eventArray[i] = (PrivilegedEvent)this.eventsObjectStore.retrieve(keys.get(i), this.eventsPartitionKey);
            }
            if (sortByArrival) {
                Arrays.sort(eventArray, new ArrivalOrderEventComparator());
            }
            return eventArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(CoreEvent event) throws ObjectStoreException {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            event = CoreEvent.builder(event).addVariable(MULE_ARRIVAL_ORDER_PROPERTY, ++this.arrivalOrderCounter).build();
            String key = this.getEventKey(event);
            this.eventsObjectStore.store(key, event, this.eventsPartitionKey);
        }
    }

    private String getEventKey(CoreEvent event) {
        StringBuilder stringBuilder = new StringBuilder();
        event.getGroupCorrelation().ifPresent(v -> stringBuilder.append(v.getSequence() + "-"));
        stringBuilder.append(event.hashCode());
        stringBuilder.append("-");
        stringBuilder.append(event.getContext().getId());
        return stringBuilder.toString();
    }

    public long getCreated() {
        return this.created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            try {
                return this.eventsObjectStore.allKeys(this.eventsPartitionKey).size();
            }
            catch (ObjectStoreException e) {
                return -1;
            }
        }
    }

    public Optional<Integer> expectedSize() {
        return Optional.ofNullable(this.expectedSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws ObjectStoreException {
        EventGroup eventGroup = this;
        synchronized (eventGroup) {
            this.eventsObjectStore.clear(this.eventsPartitionKey);
            this.eventsObjectStore.close(this.eventsPartitionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buf = new StringBuilder(80);
        buf.append(ClassUtils.getSimpleName(this.getClass()));
        buf.append(" {");
        buf.append("id=").append(this.groupId);
        buf.append(", expected size=").append(this.expectedSize().map(v -> v.toString()).orElse("<not set>"));
        try {
            EventGroup eventGroup = this;
            synchronized (eventGroup) {
                int currentSize = this.eventsObjectStore.allKeys(this.eventsPartitionKey).size();
                buf.append(", current events=").append(currentSize);
                if (currentSize > 0) {
                    buf.append(" [");
                    Iterator<String> i = this.eventsObjectStore.allKeys(this.eventsPartitionKey).iterator();
                    while (i.hasNext()) {
                        String id = i.next();
                        buf.append(this.eventsObjectStore.retrieve(id, this.eventsPartitionKey).getCorrelationId());
                        if (!i.hasNext()) continue;
                        buf.append(", ");
                    }
                    buf.append(']');
                }
            }
        }
        catch (ObjectStoreException e) {
            buf.append("ObjectStoreException " + e + " caught:" + e.getMessage());
        }
        buf.append('}');
        return buf.toString();
    }

    public CoreEvent getMessageCollectionEvent() {
        try {
            if (this.size() > 0) {
                PrivilegedEvent[] muleEvents = this.toArray(true);
                PrivilegedEvent lastEvent = muleEvents[muleEvents.length - 1];
                List messageList = Arrays.stream(muleEvents).map(event -> event.getMessage()).collect(Collectors.toList());
                Message.CollectionBuilder builder = Message.builder().collectionValue(messageList, Message.class);
                PrivilegedEvent muleEvent = PrivilegedEvent.builder(lastEvent).message(builder.build()).session(this.getMergedSession(muleEvents)).build();
                return muleEvent;
            }
            return null;
        }
        catch (ObjectStoreException e) {
            return null;
        }
    }

    protected MuleSession getMergedSession(PrivilegedEvent[] events) throws ObjectStoreException {
        DefaultMuleSession session = new DefaultMuleSession(events[0].getSession());
        for (int i = 1; i < events.length - 1; ++i) {
            this.addAndOverrideSessionProperties(session, events[i]);
        }
        this.addAndOverrideSessionProperties(session, events[events.length - 1]);
        return session;
    }

    private void addAndOverrideSessionProperties(MuleSession session, PrivilegedEvent event) {
        for (String name : event.getSession().getPropertyNamesAsSet()) {
            session.setProperty(name, event.getSession().getProperty(name));
        }
    }

    public void initAfterDeserialisation(MuleContext context) throws MuleException {
        this.muleContext = context;
    }

    public void initEventsStore(PartitionableObjectStore<CoreEvent> events) throws ObjectStoreException {
        this.eventsObjectStore = events;
        events.open(this.eventsPartitionKey);
    }

    public boolean isInitialised() {
        return this.muleContext != null;
    }

    public final class ArrivalOrderEventComparator
    implements Comparator<CoreEvent> {
        @Override
        public int compare(CoreEvent event1, CoreEvent event2) {
            return this.getEventOrder(event1) - this.getEventOrder(event2);
        }

        private int getEventOrder(CoreEvent event) {
            Integer orderVariable = (Integer)event.getVariables().get(EventGroup.MULE_ARRIVAL_ORDER_PROPERTY).getValue();
            return orderVariable != null ? orderVariable : -1;
        }
    }
}

