/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.ErrorTypeMatcher;
import org.mule.runtime.core.internal.exception.TemplateOnErrorHandler;
import org.mule.runtime.core.internal.routing.EventToMessageSequenceSplittingStrategy;
import org.mule.runtime.core.internal.routing.ExpressionSplittingStrategy;
import org.mule.runtime.core.internal.routing.MessageSequence;
import org.mule.runtime.core.internal.routing.SplittingStrategy;
import org.mule.runtime.core.internal.routing.outbound.AbstractMessageSequenceSplitter;
import org.mule.runtime.core.privileged.event.Acceptor;
import org.mule.runtime.core.privileged.expression.ExpressionConfig;
import org.mule.runtime.core.privileged.processor.Router;

public class Splitter
extends AbstractMessageSequenceSplitter
implements Initialisable,
Router {
    private ExpressionConfig config = new ExpressionConfig("#[payload]");
    private SplittingStrategy<CoreEvent, MessageSequence<?>> strategy;
    private String filterOnErrorType = null;

    public Splitter() {
    }

    public Splitter(ExpressionConfig config, String filterOnErrorType) {
        this.config = config;
        this.filterOnErrorType = filterOnErrorType;
    }

    @Override
    protected MessageSequence<?> splitMessageIntoSequence(CoreEvent event) {
        return this.strategy.split(event);
    }

    @Override
    public void initialise() throws InitialisationException {
        this.config.validate();
        this.strategy = new EventToMessageSequenceSplittingStrategy(new ExpressionSplittingStrategy(this.muleContext.getExpressionManager(), this.config.getFullExpression()));
        this.filterOnErrorTypeAcceptor = this.createFilterOnErrorTypeAcceptor(TemplateOnErrorHandler.createErrorType(this.muleContext.getErrorTypeRepository(), this.filterOnErrorType));
    }

    private Acceptor createFilterOnErrorTypeAcceptor(final ErrorTypeMatcher filterOnErrorTypeMatcher) {
        return new Acceptor(){

            @Override
            public boolean acceptsAll() {
                return false;
            }

            @Override
            public boolean accept(CoreEvent event) {
                return filterOnErrorTypeMatcher != null && filterOnErrorTypeMatcher.match(event.getError().get().getErrorType());
            }
        };
    }

    public void setExpression(String expression) {
        this.config.setExpression(expression);
    }

    public void setFilterOnErrorType(String filterOnErrorType) {
        this.filterOnErrorType = filterOnErrorType;
    }
}

